<?php $__env->startSection('page-title', 'Login'); ?>
<?php echo $__env->make('Layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <head>
        <?php echo $__env->make("Layouts.title-meta", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make("Layouts.head-css", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </head>
    <body>
        <div class="auth-page-wrapper">
            <!-- auth page bg -->
            <div class="auth-one-bg-position auth-one-bg" id="auth-particles">
                <div class="bg-overlay"></div>

                <div class="shape">
                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 1440 120">
                        <path d="M 0,36 C 144,53.6 432,123.2 720,124 C 1008,124.8 1296,56.8 1440,40L1440 140L0 140z"></path>
                    </svg>
                </div>
            </div>

            <!-- auth page content -->
            <div class="auth-page-content">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="text-center mt-sm-5 mb-4 text-white-50">
                                <div>
                                    <a href="<?php echo e(route('login')); ?>" class="d-inline-block auth-logo">
                                        <img src="<?php echo e(get_image_url(get_site_logo())); ?>" alt="" height="60">
                                    </a>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                    <!-- end row -->

                    <div class="row justify-content-center">
                        <div class="col-md-8 col-lg-6 col-xl-5">
                            <div class="card mt-4">

                                <div class="card-body p-4">
                                    <div class="text-center mt-2">
                                        <h5 class="text-primary">Welcome to Admin Portal !</h5>
                                        <p class="text-muted">Sign in to continue.</p>
                                    </div>

                                    <?php if(Session::has('error')): ?>
                                    <div class="alert alert-danger mb-2 mx-2" role="alert"><?php echo e(Session::get('error')); ?></div>
                                    <?php endif; ?>
            
                                    <?php if(Session::has('success')): ?>
                                    <div class="alert alert-success mb-2 mx-2" role="alert"><?php echo e(Session::get('success')); ?></div>
                                    <?php endif; ?>

                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="alert alert-danger mb-2 mx-2" role="alert"><?php echo $errors->first(); ?></div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <div class="p-2">

                                        <?php echo e(Form::open(['route' => 'login.do', 'id' => 'loginFrom', 'data-parsley-validate', 'autocomplete' => 'off'])); ?>

                                            <div class="mb-3">
                                                <label for="email" class="form-label">Email</label>
                                                <?php echo e(Form::email('email','',['class' => 'form-control', 'placeholder' => 'Enter email', 'id' => 'email', 'required'])); ?>

                                            </div>

                                            <div class="mb-3">
                                                <div class="float-end">
                                                    <a href="<?php echo e(route('forgot-password')); ?>" class="text-muted">Forgot password?</a>
                                                </div>
                                                <label class="form-label" for="password">Password</label>
                                                <div class="position-relative auth-pass-inputgroup mb-3">
                                                    <?php echo e(Form::password('password',['class' => 'form-control pe-5', 'placeholder' => 'Enter password', 'id' => 'password', 'required'])); ?>

                                                    
                                                </div>
                                            </div>

                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="true" id="auth-remember-check" name="remember_me">
                                                <label class="form-check-label" for="auth-remember-check">Remember me</label>
                                            </div>

                                            <div class="mt-4">
                                                <button class="btn btn-success w-100" type="submit">Sign In</button>
                                            </div>
                                        <?php echo e(Form::close()); ?>

                                    </div>
                                </div>
                                <!-- end card body -->
                            </div>
                            <!-- end card -->
                        </div>
                    </div>
                    <!-- end row -->
                </div>
                <!-- end container -->
            </div>
            <!-- end auth page content -->

            <!-- footer -->
            <footer class="footer">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="text-center">
                                <p class="mb-0 text-muted">
                                    <?php echo get_reserved_right(); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- end Footer -->
        </div>
        <!-- end auth-page-wrapper -->

        <script src="<?php echo e(asset('assets/libs/jquery/jquery.min.js?v='.env('FILE_VERSION'))); ?>"></script>
        <script src="<?php echo e(asset('assets/libs/parsleyjs/parsley.min.js?v='.env('FILE_VERSION'))); ?>"></script>

        <!-- particles js -->
        <script src="<?php echo e(asset('assets/libs/particles.js/particles.js?v='.env('FILE_VERSION'))); ?>"></script>
        <!-- particles app js -->
        <script src="<?php echo e(asset('assets/js/pages/particles.app.js?v='.env('FILE_VERSION'))); ?>"></script>
        <!-- password-addon init -->
        <script src="<?php echo e(asset('assets/js/pages/password-addon.init.js?v='.env('FILE_VERSION'))); ?>"></script>
    </body>
</html><?php /**PATH /home/cdiagk1jmlvy/public_html/goldiam/resources/views/Login/index.blade.php ENDPATH**/ ?>