<?php $__env->startSection('page-title', 'Role Management'); ?>

<?php $__env->startSection('main-content'); ?>
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Role Management</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboards</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('roles')); ?>">Role Management</a></li>
                            <li class="breadcrumb-item active">Add Role</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        <?php echo e(Form::open(['route' => 'roles.store', 'id' => 'roleFrom', 'data-parsley-validate', 'files' => true, 'autocomplete' => 'off'])); ?>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header align-items-center d-flex">
                        <h4 class="card-title mb-0 flex-grow-1">Add New Role</h4>
                    </div>
                    <div class="card-body">
                        <?php if(Session::has('error')): ?>
                        <div class="alert alert-danger mb-2" role="alert"><?php echo e(Session::get('error')); ?></div>
                        <?php endif; ?>

                        <?php if(Session::has('success')): ?>
                        <div class="alert alert-success mb-2" role="alert"><?php echo e(Session::get('success')); ?></div>
                        <?php endif; ?>

                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="alert alert-danger mb-2" role="alert"><?php echo $errors->first(); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <div class="row">
                            <div class="col-9">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                                    <?php echo e(Form::text('name', '', ['class' => 'form-control', 'placeholder' => 'Enter role name', 'id' => 'name', 'required'])); ?>

                                </div>
                            </div>
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                    <?php ($status = array('Active' => 'Active', 'Inactive' => 'Inactive')); ?>
                                    <?php echo e(Form::select('status', $status, '',['class' => 'form-select', 'required'])); ?>

                                </div>
                            </div>
                        </div>

                        <div class="border mt-3 border-dashed mb-4"></div>

                        <div class="row">
                            <div class="col-12">
                                <div id="cbWrapper" class="parsley-checkbox w-100">
                                    <div class="row">
                                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pKey => $pVal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-3 mb-4">
                                            <p class="text-muted fw-medium mb-2"><?php echo e($pKey); ?></p>
                                            <?php $__currentLoopData = $pVal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="permission[]" value="<?php echo e($val->id); ?>" <?php if($key == 0){ ?> data-parsley-mincheck="1" data-parsley-class-handler="#cbWrapper" data-parsley-errors-container="#cbErrorContainer" required="" data-parsley-required-message="Please select at least one permission." <?php } ?> data-parsley-multiple="permission" id="p<?php echo e($val->id); ?>">
                                                <label class="form-check-label" for="p<?php echo e($val->id); ?>"><?php echo e($val->display_name); ?></label>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div id="cbErrorContainer"></div>
                            </div>
                        </div>
                        
                        
                        <div class="row">
                            <div class="col-12">
                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        <?php echo e(Form::close()); ?>


    </div>
    <!-- container-fluid -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>
<script>
    $(function(){
        'use strict'

        $('#roleFrom').submit(function() {
            $('.vertical-overlay').show(); 
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cdiagk1jmlvy/public_html/goldiam/resources/views/Role/add.blade.php ENDPATH**/ ?>