<?php $__env->startSection('page-title', 'customer Management'); ?>

<?php $__env->startSection('main-content'); ?>
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">customer Management</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboards</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('customer')); ?>">Customer Management</a></li>
                            <li class="breadcrumb-item active">Add customer</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        <?php echo e(Form::open(['route' => 'customers.store', 'id' => 'customerFrom', 'data-parsley-validate', 'files' => true, 'autocomplete' => 'off'])); ?>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header align-items-center d-flex">
                        <h4 class="card-title mb-0 flex-grow-1">Add New customer</h4>
                    </div>
                    <div class="card-body">
                        <?php if(Session::has('error')): ?>
                        <div class="alert alert-danger mb-2" customer="alert"><?php echo e(Session::get('error')); ?></div>
                        <?php endif; ?>

                        <?php if(Session::has('success')): ?>
                        <div class="alert alert-success mb-2" customer="alert"><?php echo e(Session::get('success')); ?></div>
                        <?php endif; ?>

                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="alert alert-danger mb-2" customer="alert"><?php echo $errors->first(); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <div class="row">
                            <div class="col-9">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                                    <?php echo e(Form::text('name', '', ['class' => 'form-control', 'placeholder' => 'Enter customer name', 'id' => 'name', 'required'])); ?>

                                </div>
                             </div>
                           <div class="col-3">
                                <div class="mb-3">
                                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                    <?php ($status = array('Active' => 'Active', 'Inactive' => 'Inactive')); ?>
                                    <?php echo e(Form::select('status', $status, '',['class' => 'form-select', 'required'])); ?>

                                </div>
                            </div> 
                        </div>
                                 
                        <div class="row">
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="mobile_country_code" class="form-label">Country Code <span class="text-danger">*</span></label>
                                    <?php echo e(Form::select('mobile_country_code', $code, '',['class' => 'form-select', 'required', 'placeholder' => 'Please select CountryCode'])); ?>

                                </div>
                            </div>
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="mobile_no" class="form-label">Mobile Number <span class="text-danger">*</span></label>
                                    <?php echo e(Form::number('mobile_no', '', ['class' => 'form-control', 'placeholder' => 'Enter mobile no ', 'id' => 'mobile_no', 'required', 'data-parsley-mobile_no'=>"true", 'data-parsley-mobile_no-message'=>"Please provide a unique mobile_no"])); ?>

                                </div>
                            </div>
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="civil_cr_no" class="form-label">Civil Cr No </label>
                                    <?php echo e(Form::text('civil_cr_no', '', ['class' => 'form-control', 'placeholder' => 'Enter civil cr no', 'id' => 'civil_cr_no'])); ?>

                                </div>
                           </div>
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="nationality" class="form-label">Nationality </label>
                                    <?php echo e(Form::select('nationality', $country, '',['class' => 'form-select',  'placeholder' => 'Please select Nationality'])); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="address" class="form-label">Address </label>
                                    <?php echo e(Form::textarea('address', '', ['class' => 'form-control', 'placeholder' => 'Enter address', 'id' => 'address','rows'=>3])); ?>

                                </div>
                            </div>
                        </div>
                            
                        <div class="border mt-3 border-dashed mb-4"></div>
                        
                        <div class="row">
                            <div class="col-12">
                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        <?php echo e(Form::close()); ?>


    </div>
    <!-- container-fluid -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>
<script>
     $(function(){
      'use strict'

        $('#customerFrom').submit(function() {
            $('.vertical-overlay').show(); 
        });
  
        window.ParsleyValidator.addValidator('mobile_no', 
            function (value) {
                var valid = false;
                $.ajax({
                    url: '<?php echo e(route("check-moblie")); ?>',
                    data: {
                        mobile_no: value,
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    type: 'POST',
                    dataType: "JSON",
                    async: false,
                    success: function(response) {
                        valid = response.valid;
                    }
                });
                return valid;
            },
        32);
  
    });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cdiagk1jmlvy/public_html/goldiam/resources/views/Customer/add.blade.php ENDPATH**/ ?>