<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none">

<head>

    <meta charset="utf-8" />
    <title>Invoice Details | Velzon - Admin & Dashboard Template</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>">

    <!-- Layout config Js -->
    <script src="<?php echo e(asset('assets/js/layout.js')); ?>"></script>
    <!-- Bootstrap Css -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="<?php echo e(asset('assets/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="<?php echo e(asset('assets/css/app.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="<?php echo e(asset('assets/css/custom.min.css')); ?>" rel="stylesheet" type="text/css" />

</head>

<body>

 

       
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <
                    <!-- end page title -->

                    <div class="row justify-content-center">
                        <div class="col-xxl-9">
                            <div class="card" id="demo">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="card-header border-bottom-dashed p-4">
                                            <div class="d-flex">
                                                <div class="flex-grow-1">
                                                    <img src="<?php echo e(asset('assets/images/logo-dark.png')); ?>" class="card-logo card-logo-dark" alt="logo dark" height="17">
                                                    <img src="<?php echo e(asset('assets/images/logo-light.png')); ?>" class="card-logo card-logo-light" alt="logo light" height="17">
                                                    
                                                </div>
                                                
                                            </div>
                                        </div>
                                        <!--end card-header-->
                                    </div><!--end col-->
                                    <div class="col-lg-12">
                                        <div class="card-body p-4">
                                            <div class="row g-3">
                                                <div class="col-lg-3 col-6">
                                                    <p class="text-muted mb-2 text-uppercase fw-semibold">Invoice No</p>
                                                    <h5 class="fs-14 mb-0"><span id="invoice-no"><?php echo e($data->invoiceno); ?></span></h5>
                                                </div>
                                                <!--end col-->
                                                <div class="col-lg-3 col-6">
                                                    <p class="text-muted mb-2 text-uppercase fw-semibold">Date</p>
                                                    <h5 class="fs-14 mb-0"><span id="invoice-date"><?php echo e($data->invoicedate); ?></span> </h5>
                                                </div>
                                                <!--end col-->
                                                <div class="col-lg-3 col-6">
                                                    <p class="text-muted mb-2 text-uppercase fw-semibold">Payment Status</p>
                                                    <?php if($data->dueamount == 0): ?>
                                                    <span class="badge badge-soft-success fs-11" id="payment-status">Paid </span>
                                                    
                                                    <?php else: ?>
                                                        <span class="badge badge-soft-danger fs-11" id="payment-status">Due </span>
                                                    
                                                    <?php endif; ?>
                                                </div>
                                                <!--end col-->
                                                <div class="col-lg-3 col-6">
                                                    <p class="text-muted mb-2 text-uppercase fw-semibold">Total Amount</p>
                                                    <h5 class="fs-14 mb-0"><span id="total-amount"><?php echo e($data->totalamount); ?></span></h5>
                                                </div>
                                                <!--end col-->
                                            </div>
                                            <!--end row-->
                                        </div>
                                        <!--end card-body-->
                                    </div><!--end col-->
                                    <div class="col-lg-12">
                                        <div class="card-body p-4 border-top border-top-dashed">
                                            <div class="row g-3">
                                                <div class="col-6">
                                                    <h6 class="text-muted text-uppercase fw-semibold mb-3"> Address</h6>
                                                    <p class="fw-medium mb-2" id="billing-name"><?php echo e($data->customername); ?></p>
                                                    <p class="text-muted mb-1" id="billing-address-line-1"><?php echo e($data->address); ?></p>
                                                    <p class="text-muted mb-1"><span>Phone: </span><span id="billing-phone-no"><?php echo e($data->mobile_no); ?></span></p>
                                                    
                                                </div>
                                               
                                            </div>
                                            <!--end row-->
                                        </div>
                                        <!--end card-body-->
                                    </div><!--end col-->
                                    <div class="col-lg-12">
                                        <div class="card-body p-4">
                                            <div class="table-responsive">
                                                <table class="table table-borderless text-center table-nowrap align-middle mb-0">
                                                    <thead>
                                                        
                                                        <tr>
                                                            <th rowspan="2"scope="col">Sr.No.</th>   
                                                            <th rowspan="2" scope="col">Item & Discription</th>
                                                            <th rowspan="2" scope="col">QTY</th>
                                                            <th rowspan="2" scope="col">GrossWT</th>
                                                            <th colspan="2" class="text-center" scope="col">Gold</th>
                                                            <th colspan="3" class="text-center" scope="col">Diamond</th>
                                                            <th rowspan="2" scope="col"> Color StoneWTCT</th>
                                                            <th rowspan="2" scope="col">Amount KWD</th>
                                                        </tr>
                                                        <tr>
                                                            <th scope="col">Purity</th>
                                                            <th scope="col">NetWT</th>
                                                            <th scope="col">DiaWT</th>
                                                            <th scope="col">Colour</th>
                                                            <th scope="col">Clarity</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="products-list">
                                                    <?php $__currentLoopData = $sale; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sales): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($sales->id); ?> </td>
                                                    <td><?php echo e($sales->itemname); ?> </td>
                                                    <td><?php echo e($sales->quantity); ?> </td>	
                                                    <td><?php echo e($sales->grosswtgms); ?> </td>
                                                    <td><?php echo e($sales->purity); ?> </td>
                                                    <td><?php echo e($sales->netgoldwtgms); ?> </td>
                                                    <td><?php echo e($sales->diamondwtcts); ?> </td>
                                                    <td><?php echo e($sales->diamondcolour); ?> </td>
                                                    <td><?php echo e($sales->diamondclarity); ?> </td>
                                                    <td><?php echo e($sales->colorstonewtcts); ?> </td>
                                                    <td><?php echo e($sales->amount); ?> </td>
                                                </tr>  
                                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </tbody>
                                                </table><!--end table-->
                                            </div>
                                            <div class="border-top border-top-dashed mt-2">
                                                <table class="table table-borderless table-nowrap align-middle mb-0 ms-auto" style="width:250px">
                                                    <tbody>
                                                        <tr>
                                                            <td>Sub Total</td>
                                                            <td class="text-end"><?php echo e($data->totalamount); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td>Paid amount</td>
                                                            <td class="text-end"><?php echo e(($data->totalamount - $data->dueamount)); ?></td>
                                                        </tr>
                                                        <tr class="border-top border-top-dashed fs-15">
                                                            <th scope="row">Total Due Amount</th>
                                                            <th class="text-end"><?php echo e($data->dueamount); ?></th>
                                                        </tr>
                                                        

                                                    </tbody>
                                                </table>
                                                <!--end table-->
                                            </div>
                                            <div class="mt-3">
                                                <h6 class="text-muted text-uppercase fw-semibold mb-3">Payment Details:</h6>
                                                <p class="text-muted mb-1">Payment Method: <span class="fw-medium"  id="payment-method"><?php echo e($data->paymenttype); ?></span></p>
                                                
                                                <p class="text-muted">Total Amount Paid: <span class="fw-medium" id=""> </span><span id="card-total-amount"><?php echo e($data->paidamount); ?></span></p>
                                            </div>
                                            <div class="mt-4">
                                                <div class="alert alert-info">
                                                    <p class="mb-0"><span class="fw-semibold">NOTES:</span>
                                                        <span id="note">
                                                        *THE GOODS SOLD WILL BE RETURNED AND EXCHANGE WITHIN 24 HOURS WITH THE ORIGINAL INVOICE.*
                                                        </br>
                                                        *CHECK WITH THE MINISTRY OF COMMERACE AND INDUSTRY WITHIN 5 DAYS FROM THE DATE OF PURCHASE.*
                                                        </span>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="hstack gap-2 justify-content-end d-print-none mt-4">
                                            <a href="javascript:void(0);" class="btn btn-primary"><i class="ri-download-2-line align-bottom me-1"></i> Download</a>
                                            </div>
                                        </div>
                                        <!--end card-body-->
                                    </div><!--end col-->
                                </div><!--end row-->
                            </div>
                            <!--end card-->
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->

                </div><!-- container-fluid -->
            </div><!-- End Page-content -->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <script>document.write(new Date().getFullYear())</script> © Velzon.
                        </div>
                        <div class="col-sm-6">
                            <div class="text-sm-end d-none d-sm-block">
                                Design & Develop by Themesbrand
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>


    <!-- JAVASCRIPT -->
    <script src="<?php echo e(asset('assets/libs/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/libs/simplebar/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/libs/node-waves/waves.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/libs/feather-icons/feather.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/plugins/lord-icon-2.1.0.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/pages/invoicedetails.js')); ?>"></script>

    <!-- App js -->
    <script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>

</body>

</html><?php /**PATH /home/cdiagk1jmlvy/public_html/goldiam/resources/views/Salelist/view.blade.php ENDPATH**/ ?>