<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => ['guest']], function() {
    Route::get('/', ['as' => 'login', 'uses' => 'LoginController@index']);
    Route::get('/login', ['as' => 'login-home', 'uses' => 'LoginController@index']);
    Route::post('/login', ['as' => 'login.do', 'uses' => 'LoginController@login']);

    Route::get('/forgot-password', ['as' => 'forgot-password', 'uses' => 'ForgotPasswordController@index']);
    Route::post('/password/email', ['as' => 'password.email', 'uses' => 'ForgotPasswordController@sendResetLinkEmail']);
    Route::get('/password/reset/{token}', ['as' => 'password.reset', 'uses' => 'ResetPasswordController@showResetForm']);
    Route::post('/password/reset', ['as' => 'password.update', 'uses' => 'ResetPasswordController@reset']);
});

Route::group(['middleware' => ['auth']], function () {
    Route::get('/dashboard', ['as' => 'dashboard', 'uses' => 'DashboardController@index']);
    Route::get('/logout', ['as' => 'logout', 'uses' => 'DashboardController@logout']);
    Route::get('/sync-permission', ['as' => 'sync-permission', 'uses' => 'DashboardController@syncPermission']);

    Route::prefix('/site-setting')->group(function () {
        Route::get('/', ['as' => 'site-setting', 'uses' => 'SettingController@index']);
        Route::post('/', ['as' => 'update-setting', 'uses' => 'SettingController@update']);
    });

    Route::prefix('/profile')->group(function () {
        Route::get('/', ['as' => 'profile', 'uses' => 'ProfileController@index']);
        Route::post('/', ['as' => 'profile-update', 'uses' => 'ProfileController@update']);

        Route::get('/change-password', ['as' => 'change-password', 'uses' => 'ProfileController@change_password']);
        Route::post('/change-password', ['as' => 'change-password-update', 'uses' => 'ProfileController@update_password']);
    });

    Route::prefix('/roles')->group(function () {
        Route::get('/', ['as' => 'roles', 'uses' => 'RoleController@index']);
        Route::get('/ajax-list', ['as' => 'roles.ajax-list', 'uses' => 'RoleController@ajaxList']);
        Route::get('/add', ['as' => 'roles.add', 'uses' => 'RoleController@add']);
        Route::post('/add', ['as' => 'roles.store', 'uses' => 'RoleController@sales']);
        Route::get('/edit/{id}', ['as' => 'roles.edit', 'uses' => 'RoleController@edit']);
        Route::post('/edit/{id}', ['as' => 'roles.update', 'uses' => 'RoleController@update']);
        Route::post('/update-status', ['as' => 'roles.update-status', 'uses' => 'RoleController@updateStatus']);   
        Route::post('/remove', ['as' => 'roles.remove', 'uses' => 'RoleController@remove']);
    });

    Route::prefix('/users')->group(function () {
        Route::get('/', ['as' => 'users', 'uses' => 'UserController@index']);
        Route::get('/ajax-list', ['as' => 'users.ajax-list', 'uses' => 'UserController@ajaxList']);
        Route::get('/add', ['as' => 'users.add', 'uses' => 'UserController@add']);
        Route::post('/add', ['as' => 'users.store', 'uses' => 'UserController@store']);
        Route::get('/edit/{id}', ['as' => 'users.edit', 'uses' => 'UserController@edit']);
        Route::post('/edit/{id}', ['as' => 'users.update', 'uses' => 'UserController@update']);
        Route::post('/update-status', ['as' => 'users.update-status', 'uses' => 'UserController@updateStatus']);
        Route::post('/remove', ['as' => 'users.remove', 'uses' => 'UserController@remove']);
        Route::post('/check-email', ['as' => 'users.check-email', 'uses' => 'UserController@checkEmail']);
    });
       
    Route::prefix('/customer')->group(function () {
        Route::get('/', ['as' => 'customer', 'uses' => 'CustomersController@index']);
        Route::get('/ajax-list', ['as' => 'customers.ajax-list', 'uses' => 'CustomersController@ajaxList']);
        Route::get('/add', ['as' => 'customers.add', 'uses' => 'CustomersController@add']);
        Route::post('/add', ['as' => 'customers.store', 'uses' => 'CustomersController@store']);
        Route::get('/edit/{id}', ['as' => 'customers.edit', 'uses' => 'CustomersController@edit']);
        Route::post('/edit/{id}', ['as' => 'customers.update', 'uses' => 'CustomersController@update']);
        Route::post('/update-status', ['as' => 'customers.update-status', 'uses' => 'CustomersController@updateStatus']);
        Route::post('/remove', ['as' => 'customers.remove', 'uses' => 'CustomersController@remove']);
        Route::post('/check-moblie', ['as' => 'check-moblie', 'uses' => 'CustomersController@mobile']);
    });

    Route::prefix('/stocks')->group(function () {
        Route::get('/', ['as' => 'stocks', 'uses' => 'StockController@index']);
        Route::get('/ajax-list', ['as' => 'stocks.ajax-list', 'uses' => 'StockController@ajaxList']);
        Route::get('/add', ['as' => 'stocks.add', 'uses' => 'StockController@add']);
        Route::post('/add', ['as' => 'stocks.store', 'uses' => 'StockController@store']);
        Route::get('/edit/{id}', ['as' => 'stocks.edit', 'uses' => 'StockController@edit']);
        Route::post('/edit/{id}', ['as' => 'stocks.update', 'uses' => 'StockController@update']); 
        Route::post('/remove', ['as' => 'stocks.remove', 'uses' => 'StockController@remove']);
    });
    
    Route::prefix('/stockshistory')->group(function () {
        Route::get('/', ['as' => 'stockshistory', 'uses' => 'StockhistoryController@index']);
        Route::get('/ajax-list', ['as' => 'stockshistory.ajax-list', 'uses' => 'StockhistoryController@ajaxList']);
        Route::post('/remove', ['as' => 'stockshistory.remove', 'uses' => 'StockhistoryController@remove']);
    });

    Route::prefix('/sales')->group(function () {
        Route::get('/', ['as' => 'sales', 'uses' => 'SaleController@index']);
        Route::get('/ajax-list', ['as' => 'sales.ajax-list', 'uses' => 'SaleController@ajaxList']);
        Route::get('/customer', ['as' => 'sales.customer', 'uses' => 'SaleController@customer']);
        Route::post('/add', ['as' => 'sales.store', 'uses' => 'SaleController@store']);
    });

    Route::prefix('/retailers')->group(function () {
        Route::get('/', ['as' => 'retailers', 'uses' => 'RetailerController@index']);
        Route::get('/ajax-list', ['as' => 'retailers.ajax-list', 'uses' => 'RetailerController@ajaxList']);
        Route::get('/customer', ['as' => 'retailers.customer', 'uses' => 'RetailerController@customer']);
        Route::post('/add', ['as' => 'retailers.store', 'uses' => 'RetailerController@store']);
    });

    Route::prefix('/saleslist')->group(function () {
        Route::get('/', ['as' => 'saleslist', 'uses' => 'SalelistController@index']);
        Route::get('/ajax-list', ['as' => 'saleslist.ajax-list', 'uses' => 'SalelistController@ajaxList']);
        Route::get('/invoice/{id}', ['as' => 'saleslist.invoice', 'uses' => 'SalelistController@invoice']);
        Route::get('/view/{id}', ['as' => 'saleslist.view', 'uses' => 'SalelistController@view']);
        Route::get('/paymentdata', ['as' => 'saleslist.paymentdata', 'uses' => 'SalelistController@paymentdata']);
        Route::get('/paymentview', ['as' => 'saleslist.paymentview', 'uses' => 'SalelistController@paymentview']);
        Route::get('/paymenttabale', ['as' => 'saleslist.paymenttabale', 'uses' => 'SalelistController@paymenttabale']);
        Route::post('/payment', ['as' => 'saleslist.payment', 'uses' => 'SalelistController@payment']);
        Route::get('/dueamount', ['as' => 'saleslist.dueamount', 'uses' => 'SalelistController@dueamount']);
    });

    Route::prefix('/purchases')->group(function () {
        Route::get('/', ['as' => 'purchases', 'uses' => 'PurchaseController@index']);
        Route::get('/ajax-list', ['as' => 'purchases.ajax-list', 'uses' => 'PurchaseController@ajaxList']);
        Route::get('/customer', ['as' => 'purchases.customer', 'uses' => 'PurchaseController@customer']);
    });

    Route::prefix('/scrappurchaseslist')->group(function () {
        Route::get('/', ['as' => 'scrappurchaseslist', 'uses' => 'ScrappurchaselistController@index']);
             Route::get('/ajax-list', ['as' => 'scrappurchaseslist.ajax-list', 'uses' => 'ScrappurchaselistController@ajaxList']);
        Route::get('/customer', ['as' => 'scrappurchaseslist.customer', 'uses' => 'ScrappurchaselistController@customer']);
    });

    Route::prefix('/purchaseslist')->group(function () {
        Route::get('/', ['as' => 'purchaseslist', 'uses' => 'PurchaselistController@index']);
    });

});

Route::get('/clear-cache', function () {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
});

Route::get('/storage-link', function () {
    Artisan::call('storage:link');
});

Route::get('/migrate', function () {
    Artisan::call('migrate');
});