@extends('Layouts.master')
@section('page-title', 'Stocklist Management')

@section('main-content')
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">stock Management</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                            <li class="breadcrumb-item"><a href="{{route('stocks')}}">stock Management</a></li>
                            <li class="breadcrumb-item active">Add stock</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        {{ Form::open(['route' => 'stocks.store', 'id' => 'stockFrom', 'data-parsley-validate', 'files' => true, 'autocomplete' => 'off']) }}
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header align-items-center d-flex">
                        <h4 class="card-title mb-0 flex-grow-1">Add New stock</h4>
                    </div>
                    <div class="card-body">
                        @if(Session::has('error'))
                        <div class="alert alert-danger mb-2" category="alert">{{ Session::get('error') }}</div>
                        @endif

                        @if(Session::has('success'))
                        <div class="alert alert-success mb-2" category="alert">{{ Session::get('success') }}</div>
                        @endif

                        @foreach ($errors->all() as $error)
                        <div class="alert alert-danger mb-2" category="alert">{!! $errors->first() !!}</div>
                        @endforeach

                        <div class="row">
                            <div class="col-9">
                                <div class="mb-3">
                                    <label for="item" class="form-label">Item <span class="text-danger">*</span></label>
                                    {{Form::text('item', '', ['class' => 'form-control', 'placeholder' => 'Enter item', 'id' => 'item', 'required'])}}
                                </div>
                            </div>
                            
                           
                        </div>
                        <div class="row">
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="image" class="form-label">image </label>
                                    {{Form::file('image', ['class' => 'form-control', 'placeholder' => 'Select image', 'id' => 'image'])}}
                                </div>
                            </div>    
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="design" class="form-label">Design </label>
                                    {{Form::text('design', '', ['class' => 'form-control', 'placeholder' => 'Enter design', 'id' => 'design'])}}
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="supplierserialno" class="form-label">Supplier Serial No</label>
                                    {{Form::text('supplierserialno', '', ['class' => 'form-control', 'placeholder' => 'Enter supplierserialno', 'id' => 'supplierserialno'])}}
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="colorstonerate" class="form-label">Color Stone Rate </label>
                                    {{Form::text('colorstonerate','', ['class' => 'form-control', 'placeholder' => 'Enter colorstonerate', 'id' => 'colorstonerate'])}}
                                </div>
                            </div>  
                                                      
                        </div>       
                    <div class="row">
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="diamondrate" class="form-label">Diamond Rate </label>
                                    {{Form::text('diamondrate', '', ['class' => 'form-control', 'placeholder' => 'Enter diamondrate', 'id' => 'diamondrate'])}}
                                </div>
                            </div>
                            <div class="col-3">
                                 <div class="mb-3">
                                    <label for="diamondclarity" class="form-label">Diamond Clarity </label>
                                    {{Form::select('diamondclarity',array(),'',['class' => 'form-select','placeholder' => 'Please select diamondclarity'])}}
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="diamondcolour" class="form-label">Diamond Colour </label>
                                    {{Form::text('diamondcolour','', ['class' => 'form-control', 'placeholder' => 'Enter diamondcolour', 'id' => 'diamondcolour'])}}
                                </div>
                            </div> 
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="labourgold" class="form-label">Labour Gold</label>
                                    {{Form::text('labourgold', '', ['class' => 'form-control', 'placeholder' => 'Enter labourgold', 'id' => 'labourgold'])}}
                                </div>
                            </div>                                
                    </div> 
                    <div class="row">
                    <div class="col-3">
                                <div class="mb-3">
                                    <label for="netgoldwtgms" class="form-label">Net GoldWt GMS </label>
                                    {{Form::text('netgoldwtgms', '', ['class' => 'form-control', 'placeholder' => 'Enter netgoldwtcms', 'id' => 'netgoldwtgms', 'onblur' => 'calc()'])}}
                                </div>
                            </div>  
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="diamondwtcts" class="form-label">Diamond Wt CTS </label>
                                    {{Form::text('diamondwtcts', '', ['class' => 'form-control', 'placeholder' => 'Enter diamondwtcts', 'id' => 'diamondwtcts', 'onblur' => 'calc()'])}}
                                </div>
                            </div> 
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="colorstonewtcts" class="form-label">Color StoneWt CTS </label>
                                    {{Form::text('colorstonewtcts','', ['class' => 'form-control', 'placeholder' => 'Enter colorstonewtcts', 'id' => 'colorstonewtcts', 'onblur' => 'calc()'])}}
                                </div>
                            </div> 
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="grosswtgms" class="form-label">GrossWT GMS</label>
                                    {{Form::text('grosswtgms', '', ['class' => 'form-control', 'placeholder' => 'Enter grosswtgms', 'id' => 'grosswtgms'])}}
                                </div>
                            </div>                                       
                    </div> 
                    <div class="row">
                              
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="kwdcost" class="form-label">KWD Cost</label>
                                    {{Form::text('kwdcost', '', ['class' => 'form-control', 'placeholder' => 'Enter kwdcost', 'id' => 'kwdcost'])}}
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="consultancy" class="form-label">Consultancy</label>
                                    {{Form::text('consultancy','', ['class' => 'form-control', 'placeholder' => 'Enter consultancy', 'id' => 'consultancy'])}}
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="diacsamount" class="form-label">Dia+CS Amount </label>
                                    {{Form::text('diacsamount','', ['class' => 'form-control', 'placeholder' => 'Enter diacsamount', 'id' => 'diacsamount'])}}
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="customamount" class="form-label">Custom Amount </label>
                                    {{Form::text('customamount', '', ['class' => 'form-control', 'placeholder' => 'Enter customamount', 'id' => 'customamount'])}}
                                </div>
                            </div>
                                                           
                    </div> 
                    <div class="row">
                              
                            
                            <div class="col-3">
                                <div class="mb-3">
                                    <label for="totalamount" class="form-label">Total Cost </label>
                                    {{Form::text('totalamount','', ['class' => 'form-control', 'placeholder' => 'Enter totalamount', 'id' => 'totalamount'])}}
                                </div>
                            </div>
                            
                                                            
                    </div>
                   
      

                        <div class="border mt-3 border-dashed mb-4"></div>

                        <div class="row">
                            <div class="col-12">
                                <div id="cbWrapper" class="parsley-checkbox w-100">
                                    <div class="row">
                                   
                                    </div>
                                </div>
                                <div id="cbErrorContainer"></div>
                            </div>
                        </div>
                        
                        
                        <div class="row">
                            <div class="col-12">
                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        {{ Form::close() }}

    </div>
    <!-- container-fluid -->
</div>
@endsection

@section('page-css')
@endsection

@section('page-js')
<script>
   $(function(){
            $('#netgoldwtgms, #diamondwtcts,#colorstonewtcts').keyup(function(){
               var value1 = parseFloat($('#netgoldwtgms').val()) || 0;
               var value2 = parseFloat($('#diamondwtcts').val()) || 0;
               var value3= parseFloat($('#colorstonewtcts').val()) || 0;
               $('#grosswtgms').val(value1 +(value2+value3)/5);
            });
         });


 </script>
@endsection 