@extends('Layouts.master')
@section('page-title', 'Purchaselist Management')

@section('main-content')
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Sale Management</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                            <li class="breadcrumb-item"><a href="{{route('purchaseslist')}}">Purchaselist Management</a></li>
                            
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        {{ Form::open(['id' => 'purchaselistform', 'data-parsley-validate', 'files' => true, 'autocomplete' => 'off']) }}
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header align-items-center d-flex">
                        <h4 class="card-title mb-0 flex-grow-1"> Purchase </h4>
                    </div>
                    <div class="card-body">
                        @if(Session::has('error'))
                        <div class="alert alert-danger mb-2" role="alert">{{ Session::get('error') }}</div>
                        @endif

                        @if(Session::has('success'))
                        <div class="alert alert-success mb-2" role="alert">{{ Session::get('success') }}</div>
                        @endif

                        @foreach ($errors->all() as $error)
                        <div class="alert alert-danger mb-2" role="alert">{!! $errors->first() !!}</div>
                        @endforeach

                        
                        <div class="row">
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="invoicedate" class="form-label">Invoicedate  <span class="text-danger">*</span></label>
                                    {{Form::date('invoicedate', '', ['class' => 'form-control', 'placeholder' => 'select invoicedate', 'id' => 'invoicedate', 'required'])}}
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="customername" class="form-label">Customer Name <span class="text-danger">*</span></label>
                                    {{Form::text('customername', '', ['class' => 'form-control', 'placeholder' => 'Enter customer', 'id' => 'customername', 'required'])}}
                                </div>
                            </div>   
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="mobile_no" class="form-label">Mobile no <span class="text-danger">*</span></label>
                                    {{Form::text('mobile_no', '', ['class' => 'form-control', 'placeholder' => 'Enter  mobile_no', 'id' => 'mobile_no', 'required'])}}
                                </div>
                            </div>                    
                            
                        </div>
                        <div class="row">
                        <div class="col-4">
                                <div class="mb-3">
                                    <label for="civilcrno" class="form-label">Civil/CR.no  <span class="text-danger">*</span></label>
                                    {{Form::text('civilcrno', '', ['class' => 'form-control', 'placeholder' => 'Enter civilcrno', 'id' => 'civilcrno', 'required'])}}
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="nationality" class="form-label">Nationality  <span class="text-danger">*</span></label>
                                    {{Form::text('nationality', '', ['class' => 'form-control', 'placeholder' => 'Enter nationality', 'id' => 'nationality', 'required'])}}
                                </div>
                            </div>
                            <div class="col-4">
                            <div class="mb-3">
                                    <label for="address" class="form-label">Address <span class="text-danger">*</span></label>
                                    {{Form::text('address', '', ['class' => 'form-control', 'placeholder' => 'Enter address', 'id' => 'address', 'required'])}}
                                </div>
                            </div>                    
                            
                        </div>
                        
                        
                        <div class="row">
                        <div class="col-xl-12">
                            <div class="card">
                               

                                <div class="card-body">
                                    
                                    <div class="live-preview">
                                        <div class="table-responsive">
                                            <table class="table align-middle table-nowrap mb-0">
                                                <thead class="table-light">
                                                    <tr>
                                                        
                                                        <th>Item&Discription</th>
                                                        <th>Carat</th>
                                                        <th>Weight</th>
                                                        <th>AmountK.D.</th>
                                                        <th>Action</th>  
                                                    
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td>Ring </td>
                                                    <td>25 </td>
                                                    <td>250.0 </td>
                                                    <td>35000.5</td>
                                                    <td> </td>
                                                </tr>
                                                <tr>
                                                    <td>Chain </td>
                                                    <td>22 </td>
                                                    <td>122 </td>
                                                    <td>10222 </td>
                                                    <td> </td>
                                                </tr>
                                                <tr>
                                                    <td>Ring </td>
                                                    <td>122 </td>
                                                    <td>222 </td>
                                                    <td>25000 </td>
                                                    <td> </td>
                                                </tr>
                                                </tbody>
                                                
                                            </table>
                                           
                                            <!-- end table -->
                                        </div>
                                        <!-- end table responsive -->
                                    </div>
                                    <div class="d-none code-view">

                                    </div>
                                </div><!-- end card-body -->
                            </div><!-- end card -->
                        </div><!-- end col -->
                        <div class="col-xl-12">
                            <div class="card">
                               

                                <div class="card-body">
                                    
                                    <div class="live-preview">
                                        <div class="table-responsive">
                                            <table class="table align-middle table-nowrap mb-0">
                                                <thead class="table-light">
                                                    <tr>
                                                    <th>TotalAmountK.D.</th> 
                                                    <th>Bank Account</th>
                                                    <th>Pay Amount</th>
                                                    <th>Cash Account</th>
                                                    <th>Pay Amount</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td>13555</td>
                                                    <td>2999 RS/- </td>
                                                    <td>5333 RS/- </td>
                                                    <td>10% </td>
                                                    <td>12500 RS/- </td>
                                                </tr>
                                                
                                               
                                                </tbody>
                                                
                                            </table>
                                           
                                            <!-- end table -->
                                        </div>
                                        <!-- end table responsive -->
                                    </div>
                                    <div class="d-none code-view">

                                    </div>
                                </div><!-- end card-body -->
                            </div><!-- end card -->
                        </div>
                        
                   
                    </div>
                        

                        <div class="border mt-3 border-dashed mb-4"></div>
                        <div class="row">
                            <div class="col-12">
                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        {{ Form::close() }}
        

    </div>
    <!-- container-fluid -->
</div>
@endsection

@section('page-css')
@endsection

@section('page-js')
@endsection