
<html>
	<head>
		<meta charset="utf-8">
		<title>Invoice</title>
		<link rel="stylesheet" href="style.css">
		<link rel="license" href="https://www.opensource.org/licenses/mit-license/">
		<script src="script.js"></script>
    <style>
/* reset */

*
{
	border: 0;
	box-sizing: content-box;
	color: inherit;
	font-family: inherit;
	font-size: inherit;
	font-style: inherit;
	font-weight: inherit;
	line-height: inherit;
	list-style: none;
	margin: 0;
	padding: 0;
	text-decoration: none;
	vertical-align: top;
}

/* content editable */

*[contenteditable] { border-radius: 0.25em; min-width: 1em; outline: 0; }

*[contenteditable] { cursor: pointer; }

*[contenteditable]:hover, *[contenteditable]:focus, td:hover *[contenteditable], td:focus *[contenteditable], img.hover { background: #DEF; box-shadow: 0 0 1em 0.5em #DEF; }

span[contenteditable] { display: inline-block; }

/* heading */

h1 { font: bold 100% sans-serif; letter-spacing: 0.5em; text-align: center; text-transform: uppercase; }

/* table */

table { font-size: 75%; table-layout: fixed; width: 100%; }
table { border-collapse: separate; border-spacing: 2px; }
th, td { border-width: 1px; padding: 0.5em; position: relative; text-align: left; }
th, td { border-radius: 0.25em; border-style: solid; }
th { background: #EEE; border-color: #BBB; }
td { border-color: #DDD; }

/* page */

html { font: 16px/1 'Open Sans', sans-serif; overflow: auto; padding: 0.5in; }
html { background: #999; cursor: default; }

body { box-sizing: border-box; height: 11in; margin: 0 auto; overflow: hidden; padding: 0.5in; width: 10.5in; }
body { background: #FFF; border-radius: 1px; box-shadow: 0 0 1in -0.25in rgba(0, 0, 0, 0.5); }

/* header */

header { margin: 0 0 3em; }
header:after { clear: both; content: ""; display: table; }

header h1 { background: #000; border-radius: 0.25em; color: #FFF; margin: 0 0 1em; padding: 0.5em 0; }
header address { float: left; font-size: 75%; font-style: normal; line-height: 1.25; margin: 0 1em 1em 0; }
header address p { margin: 0 0 0.25em; }
header span { margin: 0 0 1em 1em; max-height: 25%; max-width: 60%; position: relative; }
header input { cursor: pointer; -ms-filter:"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)"; height: 100%; left: 0; opacity: 0; position: absolute; top: 0; width: 100%; }

/* article */

article, article address, table.meta, table.inventory { margin: 0 0 3em; }
article:after { clear: both; content: ""; display: table; }
article h1 { clip: rect(0 0 0 0); position: absolute; }

article address { float: left; font-size: 125%; font-weight: bold; }

/* table meta & balance */

table.meta, table.balance { float: right; width: 36%; }
table.meta:after, table.balance:after { clear: both; content: ""; display: table; }

/* table meta */

table.meta th { width: 40%; }


/* table items */

table.inventory { clear: both; width: 100%; }
table.inventory th { font-weight: bold; text-align: center; }



/* table balance */

table.balance th, table.balance td { width: 50%; }
table.balance td { text-align: right; }

/* aside */

aside h1 { border: none; border-width: 0 0 1px; margin: 0 0 1em; }
aside h1 { border-color: #999; border-bottom-style: solid; }

/* javascript */

.add, .cut
{
	border-width: 1px;
	display: block;
	font-size: .8rem;
	padding: 0.25em 0.5em;	
	float: left;
	text-align: center;
	width: 0.6em;
}

.add, .cut
{
	background: #9AF;
	box-shadow: 0 1px 2px rgba(0,0,0,0.2);
	background-image: -moz-linear-gradient(#00ADEE 5%, #0078A5 100%);
	background-image: -webkit-linear-gradient(#00ADEE 5%, #0078A5 100%);
	border-radius: 0.5em;
	border-color: #0076A3;
	color: #FFF;
	cursor: pointer;
	font-weight: bold;
	text-shadow: 0 -1px 2px rgba(0,0,0,0.333);
}

.note{
    font-weight: bold;
    text-align: center;
}

.add { margin: -2.5em 0 0; }

.add:hover { background: #00ADEE; }

.cut { opacity: 0; position: absolute; top: 0; left: -1.5em; }
.cut { -webkit-transition: opacity 100ms ease-in; }

tr:hover .cut { opacity: 1; }

@media print {
	* { -webkit-print-color-adjust: exact; }
	html { background: none; padding: 0; }
	body { box-shadow: none; margin: 0; }
	span:empty { display: none; }
	.add, .cut { display: none; }
}

@page { margin: 0; }

</style>
</head>
	<body>
        
		<header>
    <!--       </img src="{{asset('assets/images/pdf/goldaim.png')}}"> </img>   //-->
			<h1>Sale Invoice</h1>
			<address contenteditable>
				<h2>{{$data->customername}}</h2>
				<p>{{$data->address }}</p>
				<p>{{$data->mobile_no }}</p>
                <p>{{$data->civil_cr_no}}</p>
                <p>{{$data->nationality}}</p>
            </address>
		</header>
		<article>
			
			<address contenteditable>
				
			</address>
			<table class="meta">
				<tr>
					<th><span contenteditable>Invoice #</span></th>
					<td><span contenteditable>{{$data->invoiceno}}</span></td>
				</tr>
				<tr>
					<th><span contenteditable>Date</span></th>
					<td><span contenteditable>{{$data->invoicedate}}</span></td>
				</tr>
				<tr>
					<th><span contenteditable>Gold Rate</span></th>
					<td><span>{{$data->goldrate}}</span></td>
				</tr>
                <tr>
					<th><span contenteditable>Amount Due</span></th>
					<td><span>{{($data->totalamount - $data->paidamount)  }}</span></td>
				</tr>
			</table>
            
			<table class="inventory">
				<thead>
                    <tr>
                        <th rowspan="2"><span contenteditable>Sr.No.</span></th>   
                        <th rowspan="2"><span contenteditable>Item & Discription</span></th>
                        <th rowspan="2" ><span contenteditable>QTY</span></th>
                        <th rowspan="2"><span contenteditable>GrossWT</span></th>
                        <th colspan="2" class="text-center"><span contenteditable>Gold</span></th>
                        <th colspan="3" class="text-center"><span contenteditable>Diamond</span></th>
                        <th rowspan="2"><span contenteditable> Color StoneWTCT</span></th>
                        <th rowspan="2"><span contenteditable>Amount KWD</span></th>
                    </tr>
                    <tr>
                        <th><span contenteditable>Purity</span></th>
                        <th><span contenteditable>NetWT</span></th>
                        <th><span contenteditable>DiaWT</span></th>
                        <th><span contenteditable>Colour</span></th>
                        <th><span contenteditable>Clarity</span></th>
                    </tr>
				</thead>
				<tbody>
                    @foreach($sale as $sales)
                    <tr>
                        <td><span contenteditable>{{$sales->id}} </span></td>
                        <td><span contenteditable>{{$sales->itemname}} </span></td>
                        <td><span contenteditable>{{$sales->quantity}} </span></td>	
                        <td><span contenteditable>{{$sales->grosswtgms}} </span></td>
                        <td><span contenteditable>{{$sales->purity}} </span></td>
                        <td><span contenteditable>{{$sales->netgoldwtgms}} </span></td>
                        <td><span contenteditable>{{$sales->diamondwtcts}} </span></td>
                        <td><span contenteditable>{{$sales->diamondcolour}} </span></td>
                        <td><span contenteditable>{{$sales->diamondclarity}} </span></td>
                        <td><span contenteditable>{{$sales->colorstonewtcts}} </span></td>
                        <td><span contenteditable>{{$sales->amount}} </span></td>
                    </tr>  
                    @endforeach
				</tbody>
			</table>
			
			<table class="balance">
				<tr>
					<th><span contenteditable>Total</span></th>
					<td><span>{{$data->totalamount}}</span></td>
				</tr>
				<tr>
					<th><span contenteditable>Amount Paid</span></th>
					<td><span contenteditable>{{($data->totalamount - $data->dueamount) }}</span></td>
				</tr>
				<tr>
					<th><span contenteditable>Balance Due</span></th>
					<td><span>{{$data->dueamount}}</span></td>
				</tr>
			</table>
		</article>
		<aside>
			<h1><span contenteditable>Additional Notes</span></h1>
			<div contenteditable></br>
			<p class="note">*THE GOODS SOLD WILL BE RETURNED AND EXCHANGE WITHIN 24 HOURS WITH THE ORIGINAL INVOICE.*</p>
              </br></br>
             
            <p class="note">*CHECK WITH THE MINISTRY OF COMMERACE AND INDUSTRY WITHIN 5 DAYS FROM THE DATE OF PURCHASE.*</p>
			</div>
		</aside>
        
	</body>
</html>