@extends('Layouts.master')
@section('page-title', 'Salelist Management')

@section('main-content')
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Sale Management</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                            <li class="breadcrumb-item"><a href="{{route('sales')}}">Sale Management</a></li>
                            
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header align-items-center d-flex">
                        <h5 class="card-title mb-0 flex-grow-1">List all Sales</h5>
                       
                    </div>
                    <div class="card-body">

                        @if(Session::has('error'))
                        <div class="alert alert-danger mb-2" role="alert">{{ Session::get('error') }}</div>
                        @endif

                        @if(Session::has('success'))
                        <div class="alert alert-success mb-2" role="alert">{{ Session::get('success') }}</div>
                        @endif

                        @foreach ($errors->all() as $error)
                        <div class="alert alert-danger mb-2" role="alert">{!! $errors->first() !!}</div>
                        @endforeach

                        <table id="saleTable" class="display table table-bordered dt-responsive dataTable dtr-inline" style="width:100%">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Date</th>
                                    <th>InvoiceNo.</th>
                                    <th>CustomerName</th>
                                    <th>TotalAmount</th>
                                    <th>Due</th>
                                    <th>PaymentStatus</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                            </tbody>
                        </table>

                    </div>
                </div>
            </div><!--end col-->
        </div>
    <!-- container-fluid -->
</div>
<!-- Grids in modals -->

<div class="modal fade" id="popup" tabindex="-1" aria-labelledby="exampleModalgridLabel" aria-modal="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalgridLabel">Grid Modals</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            {{ Form::open(['route' => 'saleslist.payment', 'id' => 'paymentFrom', 'data-parsley-validate', 'files' => true, 'autocomplete' => 'off']) }}
                    <div class="row g-3">
                        <div class="col-xxl-6">
                            <div>
                                <label for="totalamount" class="form-label">Total Amount</label>
                                {{Form::text('totalamount', '', ['class' => 'form-control', 'id' => 'totalamount','readonly'])}}
                            </div>
                        </div><!--end col-->
                        <div class="col-xxl-6">
                            <div>
                                <label for="dueamount" class="form-label">Due Amount</label>
                                {{Form::text('dueamount', '', ['class' => 'form-control','id' => 'dueamount', 'readonly'])}}
                            </div>
                        </div><!--end col-->
                        
                        <div class="col-xxl-6">
                            <div>
                                <label for="paymenttype" class="form-label">PaymentMethod</label>
                                {{Form::select('paymenttype',['knet' => 'Knet','visa' => 'Visa','cash' => 'Cash'],'',['class' => 'form-select', 'required', 'placeholder' => 'PaymentMethod','id' => 'paymenttype'])}}
                            </div>
                        </div><!--end col-->
                        <div class="col-xxl-6">
                            <div>
                                <label for="duepaidamount" class="form-label">Dueamount Paid</label>
                                {{Form::text('duepaidamount', '', ['class' => 'form-control', 'placeholder' => 'Enter Duepaid Amount','id' => 'duepaidamount', 'required', 'data-parsley-duepaidamount'=>"true", 'data-parsley-duepaidamount-message'=>"Please Enter Valid Amount"])}}
                            </div>
                            <input type="hidden" id="paymentid" name="paymentid"> 
                        </div><!--end col-->
                        <div class="col-lg-12">
                            <div class="hstack gap-2 justify-content-end">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div><!--end col-->
                    </div><!--end row-->
                    {{ Form::close() }}
            </div>
        </div>
    </div>
</div>

<!-- Grids in modals -->

<div class="modal fade" id="popupview" tabindex="-1" aria-labelledby="exampleModalgridLabel" aria-modal="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalgridLabel">Grid Modals</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="javascript:void(0);">
                    <div class="row g-3">
                        <div class="col-xxl-6">
                            <div>
                                <label for="totalamount" class="form-label">Total Amount</label>
                                <input type="text" class="form-control" id="totalamount1" name="totalamount1"  placeholder="Enter totalamount" readonly>
                            </div>
                        </div><!--end col-->
                        <div class="col-xxl-6">
                            <div>
                                <label for="dueamount" class="form-label">Due Amount</label>
                                <input type="text" class="form-control" id="dueamount1" placeholder="Enter lastname" name="dueamount1" readonly>
                            </div>
                           <!-- Active Tables -->
                        </div><!--end row-->
                </form>
                <table class="table table-nowrap mb-0">
                         <thead>
                            <tr>
                                <th scope="col">Date</th>
                                <th scope="col">PaymentMethod</th>
                                <th scope="col">Amount</th>
                            </tr>
                        </thead>
                        <tbody id="payment_detail">
                        </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('page-css')
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css?v='.env('FILE_VERSION'))}}" rel="stylesheet" type="text/css" />
@endsection

@section('page-js')
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js?v='.env('FILE_VERSION'))}}"></script>
<script>
$(function(){
      'use strict'
        var oTable = $('#saleTable').DataTable({
            "processing": true,
            "bServerSide": true,
            "sAjaxSource": "{{ route('saleslist.ajax-list') }}",
            "aaSorting": [ [5, "desc"] ],
            "iDisplayLength": {{ show_per_page() }},
            "fnDrawCallback": function (oSettings) {
                feather.replace();
                $('.tooltipped').tooltip({ trigger: "hover" });
            },
            'aoColumns': [
                {"sWidth": "5%", 'bSortable': false},
                {"sWidth": "15%"},
                {"sWidth": "15%"},
                {"sWidth": "15%"},
                {"sWidth": "15%", 'bSortable': false},
                {"sWidth": "15%", "class": 'text-center'},
                {"sWidth": "10%"},
                {"sWidth": "10%", 'bSortable': false, "class": 'text-center'}
            ],
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
                lengthMenu: 'Show _MENU_ Items',
            }
        });
});


$(document).on('click','.payment_add', function(){
        var paymentid = $(this).data('id');
        $.ajax({     
                data: {id: paymentid},
                type: "GET",
                dataType: "json",
                url:"{{ route('saleslist.paymentdata') }}",
                success: function(data){ 
                $('#totalamount').val(data.totalamount);
                $('#dueamount').val(data.dueamount);
                $('#paymentid').val(paymentid);
                $("#popup").modal('show');
                }
         });
});

$(document).on('click','.payment_view', function(){
        var paymentid = $(this).data('id');
        $.ajax({     
                data: {id: paymentid},
                type: "GET",
                dataType: "json",
                url:"{{ route('saleslist.paymentview') }}",
                success: function(data){ 
                $('#totalamount1').val(data.totalamount);
                $('#dueamount1').val(data.dueamount);
                $('#paymentid').val(paymentid);
                $("#popupview").modal('show');
                }
         });
});



$(document).on('click','.payment_view', function(){
        var paymentid = $(this).data('id');
$.ajax({     
                data: {id: paymentid},
                type: "GET",
                dataType: "html",
                url:"{{ route('saleslist.paymenttabale') }}",
                success: function(data){ 
                $('#payment_detail').html(data);
                $("#popupview").modal('show');
                }
         });

 });      

$(function(){
      'use strict'

        $('#paymentFrom').submit(function() {
            $('.vertical-overlay').show(); 
        });
  
        window.ParsleyValidator.addValidator('duepaidamount', 
            function (value) {
                var value1 = parseFloat($('#paymentid').val());
                var valid = false;
                $.ajax({
                    url: "{{ route('saleslist.dueamount') }}",
                    data: {
                        duepaidamount: value,
                        paymentid: value1,
                        _token: "{{ csrf_token() }}"
                    },
                    type: 'GET',
                    dataType: "JSON",
                    async: false,
                    success: function(response) {
                        valid = response.valid;
                    }
                });
                return valid;
            },
        32);
  
});

    
</script>
@endsection