@extends('Layouts.master')
@section('page-title', 'Purchaselist Management')

@section('main-content')
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Purchaselist Management</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                            <li class="breadcrumb-item"><a href="{{route('purchaseslist')}}">Purchase Management</a></li>
                            
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header align-items-center d-flex">
                        <h5 class="card-title mb-0 flex-grow-1">List all Purchase</h5>
                        <div class="flex-shrink-0">
                            <a href="{{route('scrappurchaseslist.add')}}" class="btn btn-primary btn-label"><i class=" ri-add-line label-icon align-middle fs-16 me-2"></i> Add Purchases</a>
                        </div>
                       
                    </div>
                    <div class="card-body">

                        @if(Session::has('error'))
                        <div class="alert alert-danger mb-2" role="alert">{{ Session::get('error') }}</div>
                        @endif

                        @if(Session::has('success'))
                        <div class="alert alert-success mb-2" role="alert">{{ Session::get('success') }}</div>
                        @endif

                        @foreach ($errors->all() as $error)
                        <div class="alert alert-danger mb-2" role="alert">{!! $errors->first() !!}</div>
                        @endforeach

                        <table id="scrappurchaseTable" class="display table table-bordered dt-responsive dataTable dtr-inline" style="width:100%">
                            <thead>
                                <tr>
                                                    <th>Sr.No</th>
                                                    <th>Date</th>
                                                    <th>Order No.</th>
                                                    <th>Supplier</th>
                                                    <th>Grand Total</th>
                                                    <th>Paid</th>
                                                    <th>Due</th>
                                                    <th>PaymentStatus</th>
                                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                            </tbody>
                        </table>

                    </div>
                </div>
            </div><!--end col-->
        </div>
    <!-- container-fluid -->
</div>
@endsection

@section('page-css')
@endsection

@section('page-js')
@endsection