@extends('Layouts.master')
@section('page-title', 'Purchase Management')

@section('main-content')
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Sale Management</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                            <li class="breadcrumb-item"><a href="{{route('purchases')}}">Purchase Management</a></li>
                            <li class="breadcrumb-item active">Add Role</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        {{ Form::open(['id' => 'purchaseform', 'data-parsley-validate', 'files' => true, 'autocomplete' => 'off']) }}
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header align-items-center d-flex">
                        <h4 class="card-title mb-0 flex-grow-1"> Purchase </h4>
                    </div>
                    <div class="card-body">
                        @if(Session::has('error'))
                        <div class="alert alert-danger mb-2" role="alert">{{ Session::get('error') }}</div>
                        @endif

                        @if(Session::has('success'))
                        <div class="alert alert-success mb-2" role="alert">{{ Session::get('success') }}</div>
                        @endif

                        @foreach ($errors->all() as $error)
                        <div class="alert alert-danger mb-2" role="alert">{!! $errors->first() !!}</div>
                        @endforeach

                        
                        <div class="row">
                           
                        <div class="col-4">
                                <div class="mb-3">
                                    <label for="customername" class="form-label">Customer Name <span class="text-danger">*</span></label>
                                    {{Form::text('customername', '', ['class' => 'form-control', 'placeholder' => 'Enter customer', 'id' => 'customername', 'required'])}}
                                </div>
                            </div>
                            
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="civilcrno" class="form-label">Civil/CR.no  <span class="text-danger">*</span></label>
                                    {{Form::text('civilcrno', '', ['class' => 'form-control', 'placeholder' => 'Enter civilcrno', 'id' => 'civilcrno', 'required'])}}
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="invoiceno" class="form-label">Invoice No  <span class="text-danger">*</span></label>
                                    {{Form::text('invoiceno', '', ['class' => 'form-control', 'placeholder' => 'Enter invoiceno', 'id' => 'invoiceno', 'required'])}}
                                </div>
                            </div>
                            
                            
                        </div>
                        <div class="row">
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="mobile_no" class="form-label">Mobile no <span class="text-danger">*</span></label>
                                    {{Form::text('mobile_no', '', ['class' => 'form-control', 'placeholder' => 'Enter  mobile no', 'id' => 'mobile_no', 'required'])}}
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="nationality" class="form-label">Nationality  <span class="text-danger">*</span></label>
                                    {{Form::text('nationality', '', ['class' => 'form-control', 'placeholder' => 'Enter nationality', 'id' => 'nationality', 'required'])}}
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="invoicedate" class="form-label">Invoicedate  <span class="text-danger">*</span></label>
                                    {{Form::date('invoicedate', '', ['class' => 'form-control', 'placeholder' => 'select invoicedate', 'id' => 'invoicedate', 'required'])}}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="address" class="form-label">Address <span class="text-danger">*</span></label>
                                    {{Form::text('address', '', ['class' => 'form-control', 'placeholder' => 'Enter address', 'id' => 'address', 'required'])}}
                                </div>
                            </div>   
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="stock" class="form-label">Stock <span class="text-danger">*</span></label>  
                                    {{Form::select('stock',$stocks,'',['class' => 'form-select', 'required', 'placeholder' => 'Please select stock','id' => 'stock'])}}                                
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-2">
                                <div class="mb-3">
                                    <label for="goldrate" class="form-label">Goldrate <span class="text-danger">*</span></label>
                                    {{Form::text('goldrate', '', ['class' => 'form-control', 'placeholder' => 'Enter goldrate', 'id' => 'goldrate', 'required'])}}
                                </div>
                            </div>
                                                        
                        </div>
 
                        
                        <div class="row">
                        <div class="col-xl-12">
                            <div class="card">
                               

                                <div class="card-body">
                                    
                                    <div class="live-preview">
                                        <div class="table-responsive">
                                            <table class="table align-middle table-nowrap mb-0"  id="walsellerTable">
                                                <thead class="table-light">
                                                    <tr>
                                                    <th rowspan="2">Sr.No.</th>   
                                                    <th rowspan="2" class="text-center">Item&Discription</th>
                                                    <th rowspan="2" class="text-center">GrossWT</th>
                                                    <th colspan="2" class="text-center">Gold</th>
                                                    <th colspan="1" class="text-center">Diamond</th>
                                                    <th colspan="1" class="text-center">Color Stone</th>
                                                    <th rowspan="2" class="text-center">Total</th>
                                                    <th rowspan="2" class="text-center">Amount KWD</th>
                                                    
                                                    </tr>
                                                    <tr>
                                                    <th class="text-center">Purity</th>
                                                    <th class="text-center">NetWT</th>
                                                    <th class="text-center">WT CT</th>
                                                    <th class="text-center">WT CT</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="stock_detail">

                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <td><b> Total </b></td>
                                                        <td> </td>
                                                        <td><input type="number" id="grosswtgmstotal" name="grosswtgmstotal" class="form-control">  </td>
                                                        <td> </td>
                                                        <td><input type="number" id="netgoldwtgmstotal" name="netgoldwtgmstotal" class="form-control"> </td>
                                                        <td><input type="number" id="diamondwtctstotal" name="diamondwtctstotal" class="form-control">  </td>
                                                        <td><input type="number" id="colorstonewtctstotal" name="colorstonewtctstotal" class="form-control"> </td>
                                                        <td><input type="number" id="totalamounttotal" name="totalamounttotal" class="form-control">  </td>
                                                        <td><input type="number" id="kwdamounttotal" name="kwdamounttotal" class="form-control">  </td>
                                                        
                                                    </tr>
                                                    
                                                    <tr>
                                                        <td class="text-center"><b>Payment Type </b></td>
                                                        <td colspan="2">{{Form::select('stock',array('knet','cash','visa'),'',['class' => 'form-select', 'required', 'placeholder' => 'PaymentMethod','id' => 'paymentmethod'])}}</td>
                                                        <td><b>PaidAmount</b></td>
                                                        <td colspan="2"> <input type="number"  name="paidamount"  id="paidamount" style="width: 100px;"  class="form-control"></td> 
                                                        <td><b> Due </b></td> 
                                                        <td colspan="2" class="text-center"> <input type="number"  name="kwdamount"  id="kwdamount" style="width: 100px;"  class="form-control"></td>
                                                    </tr>
                                                       
                                                </tfoot>
                                                
                                            </table>
                                           
                                            <!-- end table -->
                                        </div>
                                        <!-- end table responsive -->
                                    </div>
                                    <div class="d-none code-view">

                                    </div>
                                </div><!-- end card-body -->
                            </div><!-- end card -->
                        </div><!-- end col -->
                       
                
                   
                    </div>
                        

                        <div class="border mt-3 border-dashed mb-4"></div>
                        <div class="row">
                            <div class="col-12">
                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        {{ Form::close() }}
        

    </div>
    <!-- container-fluid -->
</div>
@endsection

@section('page-css')
@endsection

@section('page-js')
<script>
$(document).ready (function () {  
    $("#stock").change (function () {  
        var id = $(this).children("option:selected").val();
         $.ajax({     
                data: {id: id},
                type: "GET",
                dataType: "html",
                url:"{{ route('purchases.ajax-list') }}",
                success: function(data){  
                     $('#stock_detail').append(data);
                                         
                }
            });
    });
}); 



  $(function(){
            $('#paidamount').keyup(function(){
               var value1 = parseFloat($('#paidamount').val());
               var value2 = parseFloat($('#kwdamounttotal').val());
               var due = (value2-value1);

               $('#kwdamount').val(due);
               
            }); 
  }); 

  $(document).ready( function() {
    $('#mobile_no').keyup(function() {
       var mobileno = parseInt($('#mobile_no').val());
       $.ajax({     
                data: {id: mobileno},
                type: "GET",
                dataType: "json",
                url:"{{ route('purchases.customer') }}",
                success: function(data){  
                    $('#customername').val(data.name);
                    $('#civilcrno').val(data.civil_cr_no);
                    $('#nationality').val(data.nationality);
                    $('#address').val(data.address);
                    
                                         
                }
            });
    });
});

  
         
    
</script>     

@endsection