@extends('Layouts.master')
@section('page-title', 'Profile')

@section('main-content')
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Profile</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                            <li class="breadcrumb-item active">Profile</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="card">
            <div class="card-header">
                <ul class="nav nav-tabs-custom rounded card-header-tabs border-bottom-0" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#personalDetails" role="tab">
                            <i class="fas fa-home"></i> Personal Details
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{route('change-password')}}">
                            <i class="far fa-user"></i> Change Password
                        </a>
                    </li>
                </ul>
            </div>
            <div class="card-body p-4">
                <div class="tab-content">
                    <div class="tab-pane active" id="personalDetails" role="tabpanel">
                        {{ Form::open(['route' => 'profile-update', 'id' => 'profileFrom', 'data-parsley-validate', 'files' => true, 'autocomplete' => 'off']) }}
                        
                            @if(Session::has('error'))
                            <div class="alert alert-danger mb-2" role="alert">{{ Session::get('error') }}</div>
                            @endif

                            @if(Session::has('success'))
                            <div class="alert alert-success mb-2" role="alert">{{ Session::get('success') }}</div>
                            @endif

                            @foreach ($errors->all() as $error)
                            <div class="alert alert-danger mb-2" role="alert">{!! $errors->first() !!}</div>
                            @endforeach

                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                                        {{Form::text('name', Auth::user()->name, ['class' => 'form-control', 'placeholder' => 'Enter name', 'id' => 'name', 'required'])}}
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label">Email Address</label>
                                        {{Form::email('email', Auth::user()->email, ['class' => 'form-control', 'placeholder' => 'Enter email', 'id' => 'email', 'required', 'disabled'])}}
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Updates</button>
                                    </div>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- container-fluid -->
</div>
@endsection

@section('page-css')
@endsection

@section('page-js')
<script>
    $(function(){
        'use strict'

        $('#profileFrom').submit(function() {
            $('.vertical-overlay').show(); 
        });
    });
</script>
@endsection