@section('page-title', 'Forgot Password')
@include('Layouts.main')
    <head>
        @include("Layouts.title-meta")
        @include("Layouts.head-css")
    </head>
    <body>
        <div class="auth-page-wrapper">
            <!-- auth page bg -->
            <div class="auth-one-bg-position auth-one-bg" id="auth-particles">
                <div class="bg-overlay"></div>

                <div class="shape">
                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 1440 120">
                        <path d="M 0,36 C 144,53.6 432,123.2 720,124 C 1008,124.8 1296,56.8 1440,40L1440 140L0 140z"></path>
                    </svg>
                </div>
            </div>

            <!-- auth page content -->
            <div class="auth-page-content">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="text-center mt-sm-5 mb-4 text-white-50">
                                <div>
                                    <a href="{{route('login')}}" class="d-inline-block auth-logo">
                                        <img src="{{get_image_url(get_site_logo())}}" alt="" height="60">
                                    </a>
                                </div>
                                {{-- <p class="mt-3 fs-15 fw-medium">Premium Admin & Dashboard Template</p> --}}
                            </div>
                        </div>
                    </div>
                    <!-- end row -->

                    <div class="row justify-content-center">
                        <div class="col-md-8 col-lg-6 col-xl-5">
                            <div class="card mt-4">

                                <div class="card-body p-4">
                                    <div class="text-center mt-2">
                                        <h5 class="text-primary">Forgot Password?</h5>
                                        <p class="text-muted">Reset password with velzon</p>
                                        <lord-icon src="https://cdn.lordicon.com/rhvddzym.json" trigger="loop" colors="primary:#0ab39c" class="avatar-xl"></lord-icon>
                                    </div>

                                    <div class="alert alert-borderless alert-warning mb-2 mx-2" role="alert">
                                        Enter your email and instructions will be sent to you!
                                    </div>

                                    @if(Session::has('error'))
                                    <div class="alert alert-borderless alert-danger mb-2 mx-2" role="alert">{{ Session::get('error') }}</div>
                                    @endif
            
                                    @if(Session::has('success'))
                                    <div class="alert alert-borderless alert-success mb-2 mx-2" role="alert">{{ Session::get('success') }}</div>
                                    @endif

                                    @foreach ($errors->all() as $error)
                                    <div class="alert alert-borderless alert-danger mb-2 mx-2" role="alert">{!! $errors->first() !!}</div>
                                    @endforeach

                                    <div class="p-2">

                                        {{ Form::open(['route' => 'password.email', 'id' => 'loginFrom', 'data-parsley-validate', 'autocomplete' => 'off']) }}
                                            <div class="mb-3">
                                                <label for="email" class="form-label">Email</label>
                                                {{Form::email('email','',['class' => 'form-control', 'placeholder' => 'Enter email', 'id' => 'email', 'required'])}}
                                            </div>

                                            <div class="mt-4">
                                                <button class="btn btn-success w-100" type="submit">Send Reset Link</button>
                                            </div>
                                        {{ Form::close() }}
                                    </div>
                                </div>
                                <!-- end card body -->
                            </div>
                            <!-- end card -->

                            <div class="mt-4 text-center">
                                <p class="mb-0">Wait, I remember my password... <a href="{{route('login')}}" class="fw-semibold text-primary text-decoration-underline"> Click here </a> </p>
                            </div>

                        </div>
                    </div>
                    <!-- end row -->
                </div>
                <!-- end container -->
            </div>
            <!-- end auth page content -->

            <!-- footer -->
            <footer class="footer">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="text-center">
                                <p class="mb-0 text-muted">
                                    {!! get_reserved_right() !!}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- end Footer -->
        </div>
        <!-- end auth-page-wrapper -->

        <script src="{{asset('assets/js/pages/plugins/lord-icon-2.1.0.js?v='.env('FILE_VERSION'))}}"></script>
        <script src="{{asset('assets/libs/jquery/jquery.min.js?v='.env('FILE_VERSION'))}}"></script>
        <script src="{{asset('assets/libs/parsleyjs/parsley.min.js?v='.env('FILE_VERSION'))}}"></script>

        <!-- particles js -->
        <script src="{{asset('assets/libs/particles.js/particles.js?v='.env('FILE_VERSION'))}}"></script>
        <!-- particles app js -->
        <script src="{{asset('assets/js/pages/particles.app.js?v='.env('FILE_VERSION'))}}"></script>
        <!-- password-addon init -->
        <script src="{{asset('assets/js/pages/password-addon.init.js?v='.env('FILE_VERSION'))}}"></script>
    </body>
</html>