@extends('Layouts.master')
@section('page-title', 'Dashboard')

@section('main-content')
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Dashboard</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboards</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col">
                <div class="h-100">
                    <div class="row mb-3 pb-1">
                        <div class="col-12">
                            <div class="d-flex align-items-lg-center flex-lg-row flex-column">
                                <div class="flex-grow-1">
                                    <h4 class="fs-16 mb-1">{{welcome()}}, {{Auth::user()->name}}!</h4>
                                    <p class="text-muted mb-0">Here is your personalized dashboard.</p>
                                </div>
                                <div class="mt-3 mt-lg-0">
                                    {{ Form::open(['route' => 'dashboard', 'id' => 'dashboardFrom', 'method' => 'GET', 'data-parsley-validate', 'files' => true, 'autocomplete' => 'off']) }}
                                        <div class="row g-3 mb-0 align-items-center">
                                            <div class="col-sm-auto">
                                                <div class="input-group">
                                                    <input name="date" type="text" class="form-control border-0 dash-filter-picker shadow" data-provider="flatpickr" data-range-date="true" data-date-format="d M, Y" data-maxDate="{{date('d M, Y')}}" data-deafult-date="{{$request->date}}">
                                                    <div class="input-group-text bg-primary border-primary text-white">
                                                        <i class="ri-calendar-2-line"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-auto">
                                                <button type="submit" class="btn btn-soft-success"><i class="ri-search-line align-middle me-1"></i> Search</button>
                                            </div>
                                            <!--end col-->
                                            <div class="col-auto">
                                                <a href="{{route('dashboard')}}" class="btn btn-soft-info layout-rightside-btn"><i class=" ri-filter-line"></i> Reset</a>
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    {{ Form::close() }}
                                </div>
                            </div><!-- end card header -->
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->

                    @can('dashboard')
                    
                    @endcan

                    @cannot('dashboard')
                    <div class="row">
                        <div class="col-12">
                            <div class="card card-body text-center py-2 align-items-center justify-content-center card-403">
                                <h1>403</h1>
                                <p class="card-text text-muted">Forbidden or no permission to access, Please contact your administrrator.</p>
                            </div>
                        </div>
                    </div>
                    @endcan

                </div> <!-- end .h-100-->

            </div> <!-- end col -->
        </div>

    </div>
    <!-- container-fluid -->
</div>
@endsection

@section('page-css')
<!-- jsvectormap css -->
<link href="{{asset('assets/libs/jsvectormap/css/jsvectormap.min.css?v='.env('FILE_VERSION'))}}" rel="stylesheet" type="text/css" />

<!--Swiper slider css-->
<link href="{{asset('assets/libs/swiper/swiper-bundle.min.css?v='.env('FILE_VERSION'))}}" rel="stylesheet" type="text/css" />
@endsection

@section('page-js')
<!-- apexcharts -->
<script src="{{asset('assets/libs/apexcharts/apexcharts.min.js?v='.env('FILE_VERSION'))}}"></script>

<!-- Vector map-->
<script src="{{asset('assets/libs/jsvectormap/js/jsvectormap.min.js?v='.env('FILE_VERSION'))}}"></script>
<script src="{{asset('assets/libs/jsvectormap/maps/world-merc.js?v='.env('FILE_VERSION'))}}"></script>

<!--Swiper slider js-->
<script src="{{asset('assets/libs/swiper/swiper-bundle.min.js?v='.env('FILE_VERSION'))}}"></script>

<!-- Dashboard init -->
<script src="{{asset('assets/js/pages/dashboard-ecommerce.init.js?v='.env('FILE_VERSION'))}}"></script>

<script>
    $(function(){
        'use strict'
    });
</script>
@endsection