<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('saleitems', function (Blueprint $table) {
            $table->id();
            $table->Integer('salesid');
            $table->Integer('itemid')->nullable();
            $table->string('itemname')->nullable();
            $table->Integer('quantity');
            $table->float('grosswtgms')->nullable();
            $table->float('purity')->nullable();
            $table->float('netgoldwtgms')->nullable();
            $table->float('diamondwtcts')->nullable();
            $table->string('diamondcolour')->nullable();
            $table->string('diamondclarity')->nullable();
            $table->float('colorstonewtcts')->nullable();
            $table->float('amount');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('saleitems');
    }
};
