<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->id();
            $table->Integer('customerid')->nullable();
            $table->string('customername');
            $table->bigInteger('mobile_no');
            $table->string('civil_cr_no')->nullable();
            $table->string('nationality')->nullable();
            $table->string('address')->nullable();
            $table->string('invoiceno');
            $table->date('invoicedate');
            $table->float('goldrate');
            $table->float('purity');
            $table->string('paymenttype');
            $table->float('paidamount');
            $table->float('totalamount');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales');
    }
};
