<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stocks', function (Blueprint $table) {
            $table->id();
            $table->string('image');
            $table->string('design');
            $table->string('item');
            $table->string('supplierserialno');
            $table->float('grosswtgms');
            $table->float('netgoldwtgms');
            $table->float('labourgold');
            $table->float('diamondwtcts');
            $table->float('diamondrate');
            $table->string('diamondcolour');
            $table->string('diamondclarity');
            $table->float('colorstonewtcts');
            $table->float('colorstonerate');
            $table->string('consultancy');
            $table->float('customamount');
            $table->float('diacsamount');
            $table->float('kwdcost');
            $table->float('totalamount');
            $table->float('saleamount');
            $table->enum('status', ['Available', 'Sold'])->default('Available');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stocks');
    }
};
