<?php

if (!function_exists('get_site_title')) {
    function get_site_title()
    {
        $siteTitleObj = App\Models\Setting::select('value')->where('key', 'site_title')->first();
        $siteTitle = '';
        if (!empty($siteTitleObj)) {
            $siteTitle = $siteTitleObj->value;
        }
        return $siteTitle;
    }
}

if (!function_exists('get_site_logo')) {
    function get_site_logo()
    {
        $siteTitleObj = App\Models\Setting::select('value')->where('key', 'site_logo')->first();
        $site_logo = "";
        if (!empty($siteTitleObj) && !empty($siteTitleObj->value)) {
            $site_logo = $siteTitleObj->value;
        }
        return $site_logo;
    }
}

if (!function_exists('get_reserved_right')) {
    function get_reserved_right()
    {
        $reserved_right = '';
        $siteTitleObj = App\Models\Setting::select('value')->where('key', 'reserved_right')->first();

        if (!empty($siteTitleObj)) {
            $reserved_right = $siteTitleObj->value;
        }
        return $reserved_right;
    }
}

if (!function_exists('uploadFile')) {
    function uploadFile($file, $path = '/', $old_path = '')
    {
        if (!empty($old_path)) {
            $old_file_path = str_replace('storage/', '', $old_path);
            Storage::delete($old_file_path);
        }
        
        return 'storage/' . $file->store($path);
    }
}

if (!function_exists('get_setting')) {
    function get_setting($key)
    {
        $returnStr = '-';
        $settingObj = App\Models\Setting::select('value')->where('key', $key)->first();

        if (!empty($settingObj)) {
            $returnStr = $settingObj->value;
        }
        return $returnStr;
    }
}

if (!function_exists('show_per_page')) {
    function show_per_page()
    {
        $show_per_page = 10;
        $siteTitleObj = App\Models\Setting::select('value')->where('key', 'show_item_per_page')->first();

        if (!empty($siteTitleObj)) {
            $show_per_page = $siteTitleObj->value;
        }
        return $show_per_page;
    }
}

if (!function_exists('get_image_url')) {
    function get_image_url($img,$default_image='assets/images/default.png'){
        if(empty($img)){
            return asset($default_image);
        }
        
        return asset($img);
    }
}

if (!function_exists('jsonResponse')) {
    function jsonResponse($status, $data){
        if($status){
            $jsonData = array(
                'status' => $status,
                'data' => $data
            );
        } else {
            $jsonData = array(
                'status' => $status,
                'errors' => $data
            );
        }

        return response()->json($jsonData);
    }
}

if (!function_exists('welcome')) {
    function welcome(){
        if(date("H") < 12){
            return "Good Morning";
        }elseif(date("H") > 11 && date("H") < 18){
            return "Good Afternoon";
        }elseif(date("H") > 17){
            return "Good Evening";
        }
    }
}

if (!function_exists('price_format')) {
    function price_format($price){
        return number_format($price, 2);
    }
}

if(!function_exists('invoiceNumber')){
    function invoiceNumber(){
        $orders = DB::select("SHOW TABLE STATUS LIKE 'sales'");
        $invoice = $orders[0]->Auto_increment;
        $invoice = sprintf('%07d',$invoice);
        return $invoice;
    }
}

if (!function_exists('generateBarcode')) {
    function generateBarcode(){
        $barcode = random_int(100000000000,999999999999);
        $codeArray = App\Models\Stock::where('barcodenumber',$barcode)->first();
        if(!empty($codeArray)){
           $barcode = generateBarcode();
        }
        return $barcode;
    }
}
