<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;

class Saleitems extends Model
{
    protected $fillable = ['salesid', 'itemid','itemname','quantity','grosswtgms','purity','netgoldwtgms','diamondwtcts','diamondcolour','diamondclarity','colorstonewtcts','amount'];

    public function getAllcountries($search = [], $sort = array(), $limit = null, $offset = null) {
        $saleitemObj = self::select('*');

        if ($search['freetext'] != '') {
            $saleitemObj->where(function ($query) use ($search) {
                $query->orWhere('salesid', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('itemid', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('itemname', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('quantity', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('grosswtgms', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('purity', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('netgoldwtgms', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('diamondwtcts', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('diamondcolour', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('diamondclarity', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('colorstonewtcts', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('amount', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere(DB::raw("DATE_FORMAT(created_at,'%d-%m-%Y %H:%i:%s')"), "like", "%" . $search['freetext'] . "%");
            });
        }
        $fields = array('','salesid', 'itemid','itemname','quantity','grosswtgms','purity','netgoldwtgms','diamondwtcts','diamondcolour','diamondclarity','colorstonewtcts','amount','created_at', '');
        if (!empty($sort)) {
            foreach ($sort as $index => $type) {
                if (!empty($fields[$index])) {
                    $saleitemObj->orderBy($fields[$index], $type);
                }
            }
        }

        if (empty($limit)) {
            return $saleitemObj->count();
        } else {
            $saleitemObj->offset($offset);
            $saleitemObj->limit($limit);
            return $saleitemObj->get();
        }
    }
}