<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;

class Sale extends Model
{
    protected $fillable = ['customerid', 'customername','mobile_no','civil_cr_no','nationality','address','invoicedate','goldrate','purity','dueamount','totalamount'];

    public function getAllSale($search = [], $sort = array(), $limit = null, $offset = null) {
        $saleObj = self::select('*');

        if ($search['freetext'] != '') {
            $saleObj->where(function ($query) use ($search) {
                $query->orWhere('customerid', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('customername', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('mobile_no', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('civil_cr_no', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('nationality', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('address', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('invoicedate', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('goldrate', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('purity', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('dueamount', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('totalamount', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere(DB::raw("DATE_FORMAT(created_at,'%d-%m-%Y %H:%i:%s')"), "like", "%" . $search['freetext'] . "%");
            });
        }
        $fields = array('','customerid', 'customername','mobile_no','civil_cr_no','nationality','address','invoicedate','goldrate','purity','dueamount','totalamount','created_at', '');
        if (!empty($sort)) {
            foreach ($sort as $index => $type) {
                if (!empty($fields[$index])) {
                    $saleObj->orderBy($fields[$index], $type);
                }
            }
        }

        if (empty($limit)) {
            return $saleObj->count();
        } else {
            $saleObj->offset($offset);
            $saleObj->limit($limit);
            return $saleObj->get();
        }
    }
}