<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Permission extends \Spatie\Permission\Models\Permission
{
    use HasFactory;

    protected $fillable = ['display_group', 'display_name', 'name', 'guard_name'];

    public static function defaultAdminPermissions()
    {
        return array(
            array(
                'group' => 'Dashboard',
                'name' => 'Dashboard View',
                'role' => 'dashboard',
                'guard' => 'admin'
            ),
            array(
                'group' => 'Settings',
                'name' => 'Site Setting',
                'role' => 'site-setting',
                'guard' => 'admin'
            ),
            array(
                'group' => 'Administration',
                'name' => 'Role Management',
                'role' => 'role',
                'guard' => 'admin'
            ),
            array(
                'group' => 'Administration',
                'name' => 'User Management',
                'role' => 'user',
                'guard' => 'admin'
            ),
            array(
                'group' => 'Administration',
                'name' => 'Customer Management',
                'role' => 'customer',
                'guard' => 'admin'
            ),
            array(
                'group' => 'Stock',
                'name' => 'Stock List',
                'role' => 'stock-list',
                'guard' => 'admin'
            ),
            array(
                'group' => 'Stock',
                'name' => 'Stock History',
                'role' => 'stock-history',
                'guard' => 'admin'
            ),
            array(
                'group' => 'Sale',
                'name' => 'Sale Management',
                'role' => 'sale',
                'guard' => 'admin'
            ),
            array(
                'group' => 'Purchase',
                'name' => 'Purchase Management',
                'role' => 'purchase',
                'guard' => 'admin'
            )
        );
    }

    public function scopeCheckGuard($query, $guard)
    {
        return $query->where('guard_name', $guard);
    }
}
