<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;

class Payment extends Model
{
    protected $fillable = ['paymenttype','saleid','paidamount'];

    public function getAllcountries($search = [], $sort = array(), $limit = null, $offset = null) {
        $paymentObj = self::select('*');

        if ($search['freetext'] != '') {
            $paymentObj->where(function ($query) use ($search) {
                $query->orWhere('paymenttype', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('saleid', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('paidamount', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere(DB::raw("DATE_FORMAT(created_at,'%d-%m-%Y %H:%i:%s')"), "like", "%" . $search['freetext'] . "%");
            });
        }
        $fields = array('','paymenttype','saleid','paidamount','created_at', '');
        if (!empty($sort)) {
            foreach ($sort as $index => $type) {
                if (!empty($fields[$index])) {
                    $paymentObj->orderBy($fields[$index], $type);
                }
            }
        }

        if (empty($limit)) {
            return $paymentObj->count();
        } else {
            $paymentObj->offset($offset);
            $paymentObj->limit($limit);
            return $paymentObj->get();
        }
    }
}