<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;

class Customer extends Model
{
    protected $fillable = ['name','mobile_country_code','mobile_no','civil_cr_no', 'nationality', 'address','status'];

    public function getAllcustomer($search = [], $sort = array(), $limit = null, $offset = null) {
        $customerObj = self::select('*');

        if ($search['freetext'] != '') {
            $customerObj->where(function ($query) use ($search) {
                $query->orWhere('name', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('mobile_country_code', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('mobile_no', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('civil_cr_no', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('nationality', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('address', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere('status', 'like', "%" . $search["freetext"] . "%");
                $query->orWhere(DB::raw("DATE_FORMAT(created_at,'%d-%m-%Y %H:%i:%s')"), "like", "%" . $search['freetext'] . "%");
            });
        }
        $fields = array('', 'name','mobile_country_code','mobile_no','civil_cr_no','nationality','address','status','created_at', '');
        if (!empty($sort)) {
            foreach ($sort as $index => $type) {
                if (!empty($fields[$index])) {
                    $customerObj->orderBy($fields[$index], $type);
                }
            }
        }

        if (empty($limit)) {
            return $customerObj->count();
        } else {
            $customerObj->offset($offset);
            $customerObj->limit($limit);
            return $customerObj->get();
        }
    }

    public function countrycode(){
        return $this->hasOne(Country::class, 'id', 'mobile_country_code');
    }

    public function nation(){
        return $this->hasOne(Country::class, 'id', 'nationality');
    }
}