<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller as Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use App\Models\Stock;

class StockhistoryController extends Controller
{
    public function __construct() {
        //parent::__construct();
        $this->middleware('permission:stock-history');
    }

    public function index(){
        return View('Stockhistory.index');
    }

    public function ajaxList(Request $request, Stock $stockhistoryObj){
        
        $limit = (int)$request->iDisplayLength;
        $offset = (int)$request->iDisplayStart;

        $searchContents['freetext'] = (string)$request->sSearch;
        if ($request->iSortCol_0 != '') {
            for ($i = 0; $i < $request->iSortingCols; $i++) {
                $iSortCol_ = 'iSortCol_' . $i;
                $sSortDir_ = 'sSortDir_' . $i;
                $sortcol = $request->$iSortCol_;
                $sort[$sortcol] = $request->$sSortDir_;
            }
        } else {
            $sort = null;
        }

        $stockCount = $stockhistoryObj->getAllstockshistory($searchContents);
        $stockData = $stockhistoryObj->getAllStockshistory($searchContents, $sort, $limit, $offset);
        
        $rows = array();
        $iDisplayStart = $request->iDisplayStart;

        $i=1;
        foreach ($stockData as $key => $content) {

            $action = '<div class="dropdown">
                <a href="javascript:void(0)" Stock="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="ri-more-2-fill"></i>
                </a>

                <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink1">
                    <li><a class="dropdown-item stockhistory_remove" href="javascript:void(0)" data-id="' . $content->id . '">Delete</a></li>
                </ul>
            </div>';

            

            $rowData = array(
                ($limit * $offset/$limit) + $i,
                date("d-m-Y H:i:s",strtotime($content->created_at)),
                $content->supplierserialno,
                '<img src="'.get_image_url($content->image).'" width = "20px" >',
                $content->design,
                $content->item,
                $content->grosswtgms,
                $content->netgoldwtgms,
                $content->labourgold,
                $content->diamondwtcts,                
                $content->diamondrate,
                $content->diamondcolour,                
                $content->diamondclarity,
                $content->colorstonewtcts,
                $content->colorstonerate,                
                $content->consultancy,
                $content->diacsamount,
                $content->totalamount,
                $content->customamount,
                $content->saleamount,
                $action
            );
            $rows[] = $rowData;
            $i++;
        }

        $json = array(
            'sEcho' => intval($request->sEcho),
            'iTotalRecords' => $stockCount,
            'iTotalDisplayRecords' => $stockCount,
            'aaData' => $rows
        );

        echo json_encode($json);
    }

    public function remove(Request $request){
        if($request->has('id')) {
            $stockObj = Stock::where('id', $request->id)->first();        
            $stockObj->delete();
        }
    }
}


