<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller as Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use App\Models\Stock;


class StockController extends Controller
{
    public function __construct() {
        //parent::__construct();
        $this->middleware('permission:stock-list');
    }

    public function index(){
        return View('Stock.index');
    }

    public function ajaxList(Request $request, Stock $stockObj){
        $limit = (int)$request->iDisplayLength;
        $offset = (int)$request->iDisplayStart;

        $searchContents['freetext'] = (string)$request->sSearch;
        if ($request->iSortCol_0 != '') {
            for ($i = 0; $i < $request->iSortingCols; $i++) {
                $iSortCol_ = 'iSortCol_' . $i;
                $sSortDir_ = 'sSortDir_' . $i;
                $sortcol = $request->$iSortCol_;
                $sort[$sortcol] = $request->$sSortDir_;
            }
        } else {
            $sort = null;
        }

        $stockCount = $stockObj->getAllstocks($searchContents);
        $stockData = $stockObj->getAllStocks($searchContents, $sort, $limit, $offset);
    
        $rows = array();
        $iDisplayStart = $request->iDisplayStart;

        $i=1;
        foreach ($stockData as $key => $content) {

            $action = '<div class="dropdown">
                <a href="javascript:void(0)" Stock="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="ri-more-2-fill"></i>
                </a>

                <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink1">
                    <li><a class="dropdown-item" href="'.route('stocks.edit', ['id' => $content->id]).'">Edit</a></li>
                    <li><a class="dropdown-item stock_remove" href="javascript:void(0)" data-id="' . $content->id . '">Delete</a></li>
                </ul>
            </div>';


            $rowData = array(
                ($limit * $offset/$limit) + $i,
                date("d-m-Y H:i:s",strtotime($content->created_at)),
                $content->supplierserialno,
                '<img src="'.get_image_url($content->image).'" width = "20px" >',
                $content->design,
                $content->item,
                $content->grosswtgms,
                $content->netgoldwtgms,
                $content->labourgold,
                $content->diamondwtcts,                
                $content->diamondrate,
                $content->diamondcolour,                
                $content->diamondclarity,
                $content->colorstonewtcts,
                $content->colorstonerate,                
                $content->consultancy,
                $content->diacsamount,
                $content->totalamount,
                $content->customamount,
                $content->kwdcost,
                $action
            );
            $rows[] = $rowData;
            $i++;
        }

        $json = array(
            'sEcho' => intval($request->sEcho),
            'iTotalRecords' => $stockCount,
            'iTotalDisplayRecords' => $stockCount,
            'aaData' => $rows
        );

        echo json_encode($json);
    }

    public function add(){
        
        return View('Stock.add');
    }

    public function store(Request $request){
        
        $this->validate($request, [

            'image' => 'mimes:jpeg,bmp,png',
            'item'   => 'required',
            
            
        ]);
        
        $image = $request->image;
        $imagename = NULL;
        if(!empty($image)) {
            $imagename = uploadFile($image, 'stock');
        }

        $stockObj = new Stock();
        $stockObj->image = $imagename;
        $stockObj->design = $request->design;
        $stockObj->item = $request->item;
        $stockObj->supplierserialno = $request->supplierserialno;
        $stockObj->grosswtgms =$request->grosswtgms;
        $stockObj->netgoldwtgms = $request->netgoldwtgms;
        $stockObj->diamondwtcts = $request->diamondwtcts;
        $stockObj->diamondclarity = $request->diamondclarity;
        $stockObj->diamondrate = $request->diamondrate;
        $stockObj->diamondcolour = $request->diamondcolour;
        $stockObj->labourgold = $request->labourgold;
        $stockObj->colorstonewtcts = $request->colorstonewtcts;
        $stockObj->colorstonerate = $request->colorstonerate;
        $stockObj->kwdcost = $request->kwdcost; 
        $stockObj->consultancy = $request->consultancy;
        $stockObj->diacsamount = $request->diacsamount;
        $stockObj->customamount = $request->customamount;
        $stockObj->totalamount = $request->totalamount; 
        $stockObj->barcodenumber =  generateBarcode();
         
        if($stockObj->save()){
            return redirect()->route('stocks')->with('success', 'Stock added successfully.');
        } else {
            return redirect()->back()->with('error', 'Stock not added.');
        }
    }

    public function edit($id){
        $stock = Stock::where('id', $id)->first();
         return View('Stock.edit', compact('stock'));
        
    }

    public function update($id, Request $request){
        $this->validate($request, [
            'image' => 'mimes:jpeg,bmp,png',
            'item'   => 'required',
            
            
           
        ]);

        $stockObj = Stock::where('id', $id)->first();
        if($stockObj){
            $image = $request->image;
         
            if(!empty($image)) 
            {
            $imagename = uploadFile($image, 'image',$stockObj->image);
                $stockObj->image = $imagename;
            }
        
            $stockObj->design = $request->design;
            $stockObj->item = $request->item;
            $stockObj->supplierserialno = $request->supplierserialno;
            $stockObj->grosswtgms =$request->grosswtgms;
            $stockObj->netgoldwtgms = $request->netgoldwtgms;
            $stockObj->diamondwtcts = $request->diamondwtcts;
            $stockObj->diamondclarity = $request->diamondclarity;
            $stockObj->diamondrate = $request->diamondrate;
            $stockObj->diamondcolour = $request->diamondcolour;
            $stockObj->labourgold = $request->labourgold;
            $stockObj->colorstonewtcts = $request->colorstonewtcts;
            $stockObj->colorstonerate = $request->colorstonerate;
            $stockObj->kwdcost = $request->kwdcost;
            $stockObj->consultancy = $request->consultancy;
            $stockObj->diacsamount = $request->diacsamount;
            $stockObj->customamount = $request->customamount;
            $stockObj->totalamount = $request->totalamount;
            if($stockObj->save()){ 
                return redirect()->route('stocks')->with('success', 'stocks updated successfully.');
            } else {
                return redirect()->back()->with('error', 'stocks not updated.');
            }
        } else {
            return redirect()->route('stocks')->with('success', 'stocks not found.');
        }
    }

    public function remove(Request $request){
        if($request->has('id')) {
            $stockObj = Stock::where('id', $request->id)->first();
            $stockObj->delete();
        }
    }
}


