<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller as Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use App\Models\Stock;
use App\Models\Customer;
use App\Models\Country;

class ScrappurchaselistController extends Controller
{
    public function __construct() {
        //parent::__construct();
        //$this->middleware('permission:sale');
    }

    public function index(){
        $stock = Stock::where('status','=','Available')->orderBy('id')->get();
        $stocks = array();
        foreach($stock as $sto){
                $stocks[$sto->id] = $sto->barcodenumber.' - '.$sto->item.' - '.$sto->grosswtgms.' - '.$sto->diamondwtcts; 
        }
        $stocks['Other'] = 'Other';
        return View('Scrappurchaselist.index',compact('stocks'));
    }

    public function ajaxList(Request $request){
        $id = $request->id;
        if($id == "Other"){
            return View('Scrappurchaselist.stock');
        }
        $data = Stock::where('id',$id)->first();
        return View('Scrappurchaselist.stock',compact('data'));
    }

    public function customer(Request $request){
        $id = $request->id;
        $returnData = array(
            'name' => '',
            'civil_cr_no' => '',
            'nationality' => '',
            'address' => '',
        );

        $data = Customer::where('mobile_no',$id)->first();
        if(!empty($data)){
            $returnData = array(
                'name' => $data->name,
                'civil_cr_no' => $data->civil_cr_no,
                'nationality' => !empty($data->nation)?$data->nation->nationality:'',
                'address' => $data->address,
            );
        }
        return json_encode($returnData);
    }
    

    

}  