<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller as Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use App\Models\Stock;
use App\Models\Customer;
use App\Models\Country;
use App\Models\Sale;
use App\Models\Saleitems;

class RetailerController extends Controller
{
    public function __construct() {
        //parent::__construct();
        //$this->middleware('permission:sale');
    }

    public function index(){
        $stock = Stock::where('status','=','Available')->orderBy('id')->get();
        $stocks = array();
        foreach($stock as $sto){
                $stocks[$sto->id] = $sto->barcodenumber.' - '.$sto->item.' - '.$sto->grosswtgms.' - '.$sto->diamondwtcts; 
        }
        $stocks['Other'] = 'Other';
        $invoiceno = 'SL'.invoiceNumber();
        return View('Retailer.index',compact('stocks','invoiceno'));
    }
        
    public function ajaxList(Request $request){
        $id = $request->id;
        if($id == "Other"){
            return View('Retailer.stock');
        }
        $data = Stock::where('id',$request->id)->first();
        return View('Retailer.stock',compact('data'));
    }

    public function customer(Request $request){
        $id = $request->id;
        $returnData = array(
            'name' => '',
            'civil_cr_no' => '',
            'nationality' => '',
            'address' => '',
        );

        $data = Customer::where('mobile_no',$id)->first();
        if(!empty($data)){
            $returnData = array(
                'name' => $data->name,
                'civil_cr_no' => $data->civil_cr_no,
                'nationality' => !empty($data->nation)?$data->nation->nationality:'',
                'address' => $data->address,
            );
        }
        return json_encode($returnData);
    }

    public function store(Request $request){
        
        $this->validate($request, [
            'customername'   => 'required',
            'mobile_no'   => 'required',
            'civilcrno' => 'required',
            'nationality' => 'required',
            'address' => 'required',
            'invoiceno' => 'required',
            'invoicedate' => 'required',
            'goldrate' => 'required',
            'paymenttype' => 'required',
            'paidamount' => 'required',
            'totalamount' => 'required',
        ]);
        
       
        
        $customerid = Customer::where('mobile_no',$request->mobile_no)->first();
        $country = Country::where('nationality',$request->nationality)->first();
        if(empty($customerid)){
            $customerObj = new Customer(); 
            $customerObj->name = $request->customername;
            $customerObj->civil_cr_no = $request->civilcrno;
            $customerObj->mobile_no = $request->mobile_no;
            $customerObj->nationality = $country->id;
            $customerObj->address = $request->address;
            $customerObj->save();
            $customerid = Customer::where('mobile_no',$request->mobile_no)->first();
        }
        $saleObj = new Sale();
        $saleObj->customerid = $customerid->id;
        $saleObj->saletype = $request->saletype;
        $saleObj->customername = $request->customername;
        $saleObj->mobile_no = $request->mobile_no;
        $saleObj->civil_cr_no = $request->civilcrno;
        $saleObj->nationality = $request->nationality;
        $saleObj->address = $request->address;
        $saleObj->invoicedate = $request->invoicedate;
        $saleObj->invoiceno = $request->invoiceno;
        $saleObj->goldrate = $request->goldrate;
        $saleObj->purity = $request->purity;
        $saleObj->paymenttype = $request->paymenttype;
        $saleObj->paidamount = $request->paidamount;
        $saleObj->totalamount = $request->totalamounttotal;
        $saleObj->save();
        
      
        
        foreach($request->item as $key => $val) {
            $stockid = $request->stockid[$key];
            if(empty($request->stockid[$key])){
                
                $stockObj = new Stock();
                $stockObj->item = $request->item[$key];
                $stockObj->grosswtgms = $request->grosswtgms[$key];
                $stockObj->netgoldwtgms = $request->netgoldwtgms[$key];
                $stockObj->labourgold = $request->labourgold[$key];
                $stockObj->diamondwtcts = $request->diamondwtcts[$key];
                $stockObj->diamondrate = $request->diamondrate[$key];
                $stockObj->colorstonerate = $request->colorstonerate[$key];
                $stockObj->diacsamount = $request->diacsamount[$key];
                $stockObj->colorstonewtcts = $request->colorstonewtcts[$key];
                $stockObj->barcodenumber = generateBarcode();
                $stockObj->totalamount = $request->totalamount[$key];
                $stockObj->customamount = $request->custom[$key];
                $stockObj->kwdcost = $request->kwdcost[$key];
                $stockObj->save();
                $stockid = $stockObj->id;
            }
       
        $saleitemObj = new Saleitems();
        $saleitemObj->itemid = $stockid;
        $saleitemObj->salesid = $saleObj->id;
        $saleitemObj->itemname = $request->item[$key];
        $saleitemObj->quantity = $request->qty[$key];
        $saleitemObj->grosswtgms = $request->grosswtgms[$key];
        $saleitemObj->purity = $request->Purity[$key];
        $saleitemObj->netgoldwtgms = $request->netgoldwtgms[$key];
        $saleitemObj->labourgold = $request->labourgold[$key];
        $saleitemObj->diamondrate = $request->diamondrate[$key];
        $saleitemObj->diamondwtcts =$request->diamondwtcts[$key];
        $saleitemObj->colorstonerate = $request->colorstonerate[$key];
        $saleitemObj->diacsamount = $request->diacsamount[$key];
        $saleitemObj->colorstonewtcts = $request->colorstonewtcts[$key];
        $saleitemObj->amount = $request->totalamount[$key];
        $saleitemObj->customamount = $request->custom[$key];
        $saleitemObj->kwdcost = $request->kwdcost[$key];
        $saleitemObj->save();

        Stock::where('id',$stockid)->update(['status' => 'Sold']);
    
        }
        
        
        return redirect()->route('retailers')->with('success', 'Sale added successfully.');
        
    }
    

}  
