<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
// use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    // use AuthenticatesUsers;

    public function index(){
        return view('Login.index');
    }

    public function login(Request $request){
        $this->validate($request, [
            'email'   => 'required|email',
            'password' => 'required'
        ]);

        $remember_me = ($request->remember_me)?$request->remember_me:false;
        if(Auth::attempt(array(
            'email' => $request->input('email'),
            'password' => $request->input('password'),
            'status' => 'Active'
        ),$remember_me)){
            return redirect()->route('dashboard');
        } else {
            return redirect()->back()->with('error', "Invalid email and password.");
        }
    }
}
